<?php
require_once __DIR__ . "/../src/init.php"; ensure_schema();
require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user(); $pdo = db();
$q = trim($_GET["q"] ?? "");

$sql = "SELECT c.*,
  (SELECT COUNT(*) FROM orders o WHERE o.client_id=c.id) AS orders_count,
  (SELECT MAX(COALESCE(o.end_date,o.start_date,o.created_at)) FROM orders o WHERE o.client_id=c.id) AS last_date
FROM clients c WHERE 1=1";
$params=[];
if ($q!==""){ $like="%$q%"; $sql.=" AND (c.name LIKE ? OR c.phone LIKE ? OR c.email LIKE ? OR c.address LIKE ? OR c.note LIKE ?)";
  $params=[$like,$like,$like,$like,$like];
}
$sql.=" ORDER BY c.name ASC LIMIT 500";
$st=$pdo->prepare($sql); $st->execute($params); $clients=$st->fetchAll();
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Klienti – Podlahářství</title><link rel="stylesheet" href="assets/style.css">
</head><body>
<header class="topbar">
  <div class="brand"><div class="logo">👥</div><div>
    <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Klienti</div>
    <div class="brand-sub">Přihlášen: <?=h($u["name"])?> (<?=h($u["role"])?>)</div>
  </div></div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a href="orders.php">Zakázky</a>
    <a href="calendar.php">Kalendář</a>
    <a class="active" href="clients.php">Klienti</a>
    <a href="pricelist.php">Ceník</a>
    <a href="logout.php">Odhlásit</a>
  </nav>
</header>
<main class="container">
  <section class="panel">
    <div class="panel-head"><h2>Seznam klientů</h2><div class="muted">Klient se vytvoří automaticky při zakázce.</div></div>
    <div class="panel-body">
      <form method="get" class="grid" style="margin-bottom:12px">
        <label class="field span-2"><span class="muted">Hledat</span>
          <input class="input" name="q" value="<?=h($q)?>" placeholder="jméno, telefon, adresa…"></label>
        <div class="field"><span class="muted">&nbsp;</span><button class="btn" type="submit">Filtrovat</button></div>
      </form>
      <div class="table-wrap"><table class="table">
        <thead><tr><th>Klient</th><th>Kontakt</th><th>Zakázky</th><th>Poslední</th><th>Akce</th></tr></thead>
        <tbody>
        <?php foreach($clients as $c): ?>
          <tr>
            <td><strong><?=h($c["name"])?></strong><div class="muted"><?=h($c["address"]??"")?></div></td>
            <td class="muted"><?=h($c["phone"]??"—")?><?= $c["email"] ? " • ".h($c["email"]) : "" ?></td>
            <td><?= (int)$c["orders_count"] ?></td>
            <td class="muted"><?=h((string)($c["last_date"]??"—"))?></td>
            <td><a class="btn" href="client_view.php?id=<?=(int)$c["id"]?>">Detail</a></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table></div>
    </div>
  </section>
</main>
</body></html>
