<?php
require_once __DIR__ . "/../src/init.php"; ensure_schema();
require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login(); require_role("admin");

$cfg = require __DIR__ . "/../src/config.php";
$u=current_user(); $pdo=db();
$msg="";

if($_SERVER["REQUEST_METHOD"]==="POST"){
  $name=trim($_POST["name"]??""); $email=trim($_POST["email"]??""); $pass=$_POST["password"]??""; $role=$_POST["role"]??"montér";
  if($name && $email && $pass){
    $hash=password_hash($pass, PASSWORD_DEFAULT);
    try{
      $st=$pdo->prepare("INSERT INTO users (name,email,password_hash,role,is_active) VALUES (?,?,?,?,1)");
      $st->execute([$name,$email,$hash,$role]);
      $msg="Uživatel vytvořen.";
    }catch(Throwable $e){ $msg="Nelze vytvořit uživatele (email už existuje?)"; }
  } else $msg="Vyplň jméno, email a heslo.";
}

$users=$pdo->query("SELECT id,name,email,role,is_active,created_at FROM users ORDER BY created_at DESC")->fetchAll();
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Uživatelé – Podlahářství</title><link rel="stylesheet" href="assets/style.css">
</head><body>
<header class="topbar">
  <div class="brand"><div class="logo">🔐</div><div>
    <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Uživatelé</div>
    <div class="brand-sub">Admin: <?=h($u["name"])?></div>
  </div></div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a href="orders.php">Zakázky</a>
    <a href="calendar.php">Kalendář</a>
    <a href="clients.php">Klienti</a>
    <a href="pricelist.php">Ceník</a>
    <a class="active" href="users.php">Uživatelé</a>
    <a href="logout.php">Odhlásit</a>
  </nav>
</header>

<main class="container">
  <?php if($msg): ?><div class="notice"><?=h($msg)?></div><?php endif; ?>
  <section class="panel">
    <div class="panel-head"><h2>Vytvořit uživatele</h2></div>
    <div class="panel-body">
      <form method="post" class="grid-3">
        <label class="field"><span class="muted">Jméno</span><input class="input" name="name" required></label>
        <label class="field"><span class="muted">Email</span><input class="input" name="email" type="email" required></label>
        <label class="field"><span class="muted">Heslo</span><input class="input" name="password" type="password" required></label>
        <label class="field"><span class="muted">Role</span>
          <select class="input" name="role">
            <option value="montér">montér</option>
            <option value="office">office</option>
            <option value="admin">admin</option>
          </select>
        </label>
        <div class="field"><span class="muted">&nbsp;</span><button class="btn btn-primary" type="submit">Vytvořit</button></div>
      </form>
      <div class="muted" style="margin-top:10px">Default: admin@local/admin123, office@local/office123.</div>
    </div>
  </section>

  <section class="panel">
    <div class="panel-head"><h2>Seznam</h2></div>
    <div class="panel-body">
      <div class="table-wrap"><table class="table">
        <thead><tr><th>ID</th><th>Jméno</th><th>Email</th><th>Role</th><th>Aktivní</th><th>Vytvořeno</th></tr></thead>
        <tbody>
          <?php foreach($users as $x): ?>
            <tr>
              <td class="muted">#<?= (int)$x["id"] ?></td>
              <td><strong><?=h($x["name"])?></strong></td>
              <td class="muted"><?=h($x["email"])?></td>
              <td><?=h($x["role"])?></td>
              <td><?= (int)$x["is_active"]===1 ? "Ano" : "Ne" ?></td>
              <td class="muted"><?=h((string)$x["created_at"])?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table></div>
    </div>
  </section>
</main>
</body></html>
