<?php
declare(strict_types=1);

require_once __DIR__ . "/db.php";

function h(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES, "UTF-8");
}

function czk(int|float $n): string {
  $v = (float)$n;
  return number_format($v, 0, ",", " ") . " Kč";
}

function order_totals(int $orderId): array {
  $pdo = db();

  $stmt = $pdo->prepare("SELECT COALESCE(SUM(qty * unit_price_czk),0) AS subtotal FROM order_items WHERE order_id=?");
  $stmt->execute([$orderId]);
  $subtotal = (float)$stmt->fetch()["subtotal"];

  $o = $pdo->prepare("SELECT vat_rate, discount_czk FROM orders WHERE id=?");
  $o->execute([$orderId]);
  $row = $o->fetch();
  $vatRate = (float)($row["vat_rate"] ?? 21.0);
  $discount = (int)($row["discount_czk"] ?? 0);

  $afterDiscount = max(0.0, $subtotal - $discount);
  $vat = $afterDiscount * ($vatRate / 100.0);
  $total = $afterDiscount + $vat;

  return [
    "subtotal" => $subtotal,
    "discount" => $discount,
    "after_discount" => $afterDiscount,
    "vat_rate" => $vatRate,
    "vat" => $vat,
    "total" => $total,
  ];
}
