<?php
declare(strict_types=1);

require_once __DIR__ . "/db.php";

function start_session(): void {
  if (session_status() === PHP_SESSION_NONE) session_start();
}

function current_user(): ?array {
  start_session();
  return $_SESSION["user"] ?? null;
}

function require_login(): void {
  if (!current_user()) {
    header("Location: login.php");
    exit;
  }
}

function login(string $email, string $password): bool {
  start_session();
  $stmt = db()->prepare("SELECT id, name, email, password_hash, role, is_active FROM users WHERE email = ? LIMIT 1");
  $stmt->execute([$email]);
  $u = $stmt->fetch();

  if (!$u || (int)$u["is_active"] !== 1) return false;
  if (!password_verify($password, $u["password_hash"])) return false;

  $_SESSION["user"] = [
    "id" => (int)$u["id"],
    "name" => $u["name"],
    "email" => $u["email"],
    "role" => $u["role"],
  ];
  return true;
}

function logout(): void {
  start_session();
  $_SESSION = [];
  session_destroy();
}
