<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user();

$pdo = db();
$id = (int)($_GET["id"] ?? 0);
$isEdit = $id > 0;

$users = $pdo->query("SELECT id, name, role FROM users WHERE is_active=1 ORDER BY name")->fetchAll();

$order = [
  "client_id" => 0,
  "title" => "",
  "address" => "",
  "flooring_type" => "Vinyl",
  "area_m2" => "0",
  "status" => "Čeká",
  "start_date" => "",
  "end_date" => "",
  "assigned_user_id" => null,
  "note" => "",
  "vat_rate" => "21.00",
  "discount_czk" => "0",
];

$client = ["name"=>"", "phone"=>"", "email"=>"", "address"=>"", "ico"=>"", "dic"=>"", "note"=>""];

if ($isEdit) {
  $stmt = $pdo->prepare("SELECT * FROM orders WHERE id=?");
  $stmt->execute([$id]);
  $order = $stmt->fetch();
  if (!$order) { http_response_code(404); exit("Zakázka nenalezena"); }

  $c = $pdo->prepare("SELECT * FROM clients WHERE id=?");
  $c->execute([(int)$order["client_id"]]);
  $client = $c->fetch() ?: $client;
}

$items = [];
if ($isEdit) {
  $it = $pdo->prepare("SELECT * FROM order_items WHERE order_id=? ORDER BY id ASC");
  $it->execute([$id]);
  $items = $it->fetchAll();
}

$notice = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $client["name"] = trim($_POST["client_name"] ?? "");
  $client["phone"] = trim($_POST["client_phone"] ?? "");
  $client["email"] = trim($_POST["client_email"] ?? "");
  $client["address"] = trim($_POST["client_address"] ?? "");
  $client["ico"] = trim($_POST["client_ico"] ?? "");
  $client["dic"] = trim($_POST["client_dic"] ?? "");
  $client["note"] = trim($_POST["client_note"] ?? "");

  $order["title"] = trim($_POST["title"] ?? "");
  $order["address"] = trim($_POST["address"] ?? "");
  $order["flooring_type"] = trim($_POST["flooring_type"] ?? "");
  $order["area_m2"] = (string)floatval($_POST["area_m2"] ?? 0);
  $order["status"] = trim($_POST["status"] ?? "Čeká");
  $order["start_date"] = $_POST["start_date"] ?: null;
  $order["end_date"] = $_POST["end_date"] ?: null;
  $order["assigned_user_id"] = ($_POST["assigned_user_id"] ?? "") !== "" ? (int)$_POST["assigned_user_id"] : null;
  $order["note"] = trim($_POST["note"] ?? "");
  $order["vat_rate"] = (string)floatval($_POST["vat_rate"] ?? 21);
  $order["discount_czk"] = (string)intval($_POST["discount_czk"] ?? 0);

  if ($client["name"] === "" || $order["title"] === "" || $order["address"] === "") {
    $notice = "Vyplň klienta, název zakázky a adresu.";
  } else {
    $pdo->beginTransaction();
    try {
      if ($isEdit) {
        $updC = $pdo->prepare("UPDATE clients SET name=?, phone=?, email=?, address=?, ico=?, dic=?, note=? WHERE id=?");
        $updC->execute([$client["name"],$client["phone"],$client["email"],$client["address"],$client["ico"],$client["dic"],$client["note"], (int)$order["client_id"]]);
        $clientId = (int)$order["client_id"];
      } else {
        $insC = $pdo->prepare("INSERT INTO clients (name, phone, email, address, ico, dic, note) VALUES (?,?,?,?,?,?,?)");
        $insC->execute([$client["name"],$client["phone"],$client["email"],$client["address"],$client["ico"],$client["dic"],$client["note"]]);
        $clientId = (int)$pdo->lastInsertId();
      }

      if ($isEdit) {
        $updO = $pdo->prepare("UPDATE orders SET client_id=?, title=?, address=?, flooring_type=?, area_m2=?, status=?, start_date=?, end_date=?, assigned_user_id=?, note=?, vat_rate=?, discount_czk=? WHERE id=?");
        $updO->execute([$clientId,$order["title"],$order["address"],$order["flooring_type"],$order["area_m2"],$order["status"],$order["start_date"],$order["end_date"],$order["assigned_user_id"],$order["note"],$order["vat_rate"],$order["discount_czk"], $id]);
      } else {
        $insO = $pdo->prepare("INSERT INTO orders (client_id,title,address,flooring_type,area_m2,status,start_date,end_date,assigned_user_id,note,vat_rate,discount_czk) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
        $insO->execute([$clientId,$order["title"],$order["address"],$order["flooring_type"],$order["area_m2"],$order["status"],$order["start_date"],$order["end_date"],$order["assigned_user_id"],$order["note"],$order["vat_rate"],$order["discount_czk"]]);
        $id = (int)$pdo->lastInsertId();
        $isEdit = true;
      }

      if (isset($_POST["add_item"]) && $_POST["add_item"] === "1") {
        $name = trim($_POST["item_name"] ?? "");
        if ($name !== "") {
          $kind = trim($_POST["item_kind"] ?? "Materiál");
          $unit = trim($_POST["item_unit"] ?? "ks");
          $qty  = (float)($_POST["item_qty"] ?? 1);
          $price = (int)($_POST["item_unit_price_czk"] ?? 0);
          $noteI = trim($_POST["item_note"] ?? "");
          $insI = $pdo->prepare("INSERT INTO order_items (order_id,kind,name,unit,qty,unit_price_czk,note) VALUES (?,?,?,?,?,?,?)");
          $insI->execute([$id,$kind,$name,$unit,$qty,$price,$noteI]);
        }
      }

      if (isset($_POST["delete_item_id"]) && $_POST["delete_item_id"] !== "") {
        $delId = (int)$_POST["delete_item_id"];
        $del = $pdo->prepare("DELETE FROM order_items WHERE id=? AND order_id=?");
        $del->execute([$delId, $id]);
      }

      $pdo->commit();
      header("Location: order_view.php?id=".$id);
      exit;
    } catch (Throwable $e) {
      $pdo->rollBack();
      $notice = "Chyba při ukládání.";
    }
  }
}

$totals = $isEdit ? order_totals($id) : ["subtotal"=>0,"discount"=>0,"after_discount"=>0,"vat_rate"=>$order["vat_rate"],"vat"=>0,"total"=>0];
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= $isEdit ? "Upravit" : "Nová" ?> zakázku – Podlahářství</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
<header class="topbar">
  <div class="brand">
    <div class="logo">🧱</div>
    <div>
      <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – <?= $isEdit ? "Upravit" : "Nová" ?> zakázka</div>
      <div class="brand-sub">Přihlášen: <?=h($u["name"])?> (<?=h($u["role"])?>)</div>
    </div>
  </div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a class="active" href="orders.php">Zakázky</a>
    <a href="calendar.php">Kalendář</a>
    <a href="logout.php">Odhlásit</a>
  </nav>
</header>

<main class="container">
  <?php if ($notice): ?>
    <div class="notice bad"><?=h($notice)?></div>
  <?php endif; ?>

  <form method="post" class="panel">
    <div class="panel-head">
      <h2><?= $isEdit ? ("Zakázka #".$id) : "Nová zakázka" ?></h2>
      <div class="right">
        <?php if ($isEdit): ?>
          <a class="btn" href="order_view.php?id=<?=$id?>">Zpět na detail</a>
        <?php endif; ?>
        <button class="btn btn-primary" type="submit">Uložit</button>
      </div>
    </div>

    <div class="panel-body">
      <div class="grid">
        <div class="span-2"><strong>Klient</strong></div>
        <label class="field"><span class="muted">Jméno / firma</span><input class="input" name="client_name" value="<?=h($client["name"])?>" required></label>
        <label class="field"><span class="muted">Telefon</span><input class="input" name="client_phone" value="<?=h($client["phone"] ?? "")?>"></label>
        <label class="field"><span class="muted">Email</span><input class="input" name="client_email" value="<?=h($client["email"] ?? "")?>"></label>
        <label class="field"><span class="muted">Fakturační adresa</span><input class="input" name="client_address" value="<?=h($client["address"] ?? "")?>"></label>
        <label class="field"><span class="muted">IČO</span><input class="input" name="client_ico" value="<?=h($client["ico"] ?? "")?>"></label>
        <label class="field"><span class="muted">DIČ</span><input class="input" name="client_dic" value="<?=h($client["dic"] ?? "")?>"></label>
        <label class="field span-2"><span class="muted">Poznámka ke klientovi</span><textarea class="input" name="client_note" rows="2"><?=h($client["note"] ?? "")?></textarea></label>

        <div class="span-2" style="margin-top:6px"><strong>Zakázka</strong></div>
        <label class="field span-2"><span class="muted">Název zakázky</span><input class="input" name="title" value="<?=h($order["title"])?>" required></label>
        <label class="field span-2"><span class="muted">Realizační adresa</span><input class="input" name="address" value="<?=h($order["address"])?>" required></label>

        <label class="field"><span class="muted">Typ krytiny</span>
          <select class="input" name="flooring_type">
            <?php foreach (["Vinyl","Laminát","Dřevo","Koberec","PVC","Epoxid"] as $t): ?>
              <option <?= $order["flooring_type"]===$t?"selected":"" ?>><?=h($t)?></option>
            <?php endforeach; ?>
          </select>
        </label>

        <label class="field"><span class="muted">Plocha (m²)</span><input class="input" name="area_m2" type="number" step="0.01" value="<?=h((string)$order["area_m2"])?>"></label>

        <label class="field"><span class="muted">Status</span>
          <select class="input" name="status">
            <?php foreach (["Čeká","V běhu","Hotovo","Zrušeno"] as $st): ?>
              <option <?= $order["status"]===$st?"selected":"" ?>><?=h($st)?></option>
            <?php endforeach; ?>
          </select>
        </label>

        <label class="field"><span class="muted">Montér</span>
          <select class="input" name="assigned_user_id">
            <option value="">—</option>
            <?php foreach ($users as $uu): ?>
              <option value="<?=(int)$uu["id"]?>" <?= (string)$order["assigned_user_id"]===(string)$uu["id"] ? "selected":"" ?>>
                <?=h($uu["name"])?> (<?=h($uu["role"])?>)
              </option>
            <?php endforeach; ?>
          </select>
        </label>

        <label class="field"><span class="muted">Začátek</span><input class="input" name="start_date" type="date" value="<?=h((string)($order["start_date"] ?? ""))?>"></label>
        <label class="field"><span class="muted">Konec</span><input class="input" name="end_date" type="date" value="<?=h((string)($order["end_date"] ?? ""))?>"></label>

        <label class="field span-2"><span class="muted">Poznámka</span><textarea class="input" name="note" rows="3"><?=h($order["note"] ?? "")?></textarea></label>

        <div class="span-2" style="margin-top:6px"><strong>Rozpočet</strong> <span class="muted">(položkově)</span></div>
        <label class="field"><span class="muted">DPH (%)</span><input class="input" name="vat_rate" type="number" step="0.01" value="<?=h((string)$order["vat_rate"])?>"></label>
        <label class="field"><span class="muted">Sleva (CZK)</span><input class="input" name="discount_czk" type="number" step="1" value="<?=h((string)$order["discount_czk"])?>"></label>
      </div>

      <?php if ($isEdit): ?>
        <div class="panel" style="margin-top:14px">
          <div class="panel-head">
            <h2>Položky</h2>
            <div class="muted">Mezisoučet: <?=czk((int)$totals["subtotal"])?> • Celkem s DPH: <?=czk((int)round($totals["total"]))?></div>
          </div>
          <div class="panel-body">
            <div class="table-wrap">
              <table class="table">
                <thead>
                  <tr>
                    <th>Druh</th><th>Název</th><th>MJ</th><th>Množství</th><th>Cena/MJ</th><th>Řádek</th><th>Akce</th>
                  </tr>
                </thead>
                <tbody>
                <?php foreach ($items as $it): ?>
                  <?php $rowSum = (float)$it["qty"] * (int)$it["unit_price_czk"]; ?>
                  <tr>
                    <td><?=h($it["kind"])?></td>
                    <td><strong><?=h($it["name"])?></strong><div class="muted"><?=h($it["note"] ?? "")?></div></td>
                    <td><?=h($it["unit"])?></td>
                    <td><?=h((string)$it["qty"])?></td>
                    <td><?=czk((int)$it["unit_price_czk"])?></td>
                    <td><?=czk((int)round($rowSum))?></td>
                    <td>
                      <button class="btn btn-danger" name="delete_item_id" value="<?=(int)$it["id"]?>" type="submit" onclick="return confirm('Smazat položku?')">Smazat</button>
                    </td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>

            <div class="notice" style="margin-top:12px">
              <strong>Přidat položku</strong>
              <div class="grid-3" style="margin-top:10px">
                <label class="field"><span class="muted">Druh</span>
                  <select class="input" name="item_kind">
                    <option>Materiál</option><option>Práce</option><option>Doprava</option><option>Ostatní</option>
                  </select>
                </label>
                <label class="field"><span class="muted">MJ</span><input class="input" name="item_unit" value="ks"></label>
                <label class="field"><span class="muted">Množství</span><input class="input" name="item_qty" type="number" step="0.01" value="1"></label>

                <label class="field span-2"><span class="muted">Název</span><input class="input" name="item_name" placeholder="např. Vinyl, lepidlo, nivelace, práce…" ></label>
                <label class="field"><span class="muted">Cena/MJ (CZK)</span><input class="input" name="item_unit_price_czk" type="number" step="1" value="0"></label>

                <label class="field span-2"><span class="muted">Poznámka</span><input class="input" name="item_note" placeholder="např. tl. 2.5mm, včetně lišt…"></label>
                <div class="field">
                  <span class="muted">&nbsp;</span>
                  <button class="btn btn-primary" name="add_item" value="1" type="submit">Přidat</button>
                </div>
              </div>
            </div>

            <div class="right" style="margin-top:12px">
              <a class="btn" href="print.php?id=<?=$id?>&doc=nabidka" target="_blank">Tisk nabídky</a>
              <a class="btn" href="print.php?id=<?=$id?>&doc=zakazka" target="_blank">Tisk zakázky</a>
              <a class="btn" href="print.php?id=<?=$id?>&doc=protokol" target="_blank">Předávací protokol</a>
            </div>
          </div>
        </div>
      <?php else: ?>
        <div class="muted" style="margin-top:10px">Položky rozpočtu přidáš po prvním uložení zakázky.</div>
      <?php endif; ?>
    </div>
  </form>
</main>
</body>
</html>
