<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user();

$pdo = db();
$stats = $pdo->query("
  SELECT
    COUNT(*) AS total,
    SUM(CASE WHEN status='Čeká' THEN 1 ELSE 0 END) AS wait_count,
    SUM(CASE WHEN status='V běhu' THEN 1 ELSE 0 END) AS run_count,
    SUM(CASE WHEN status='Hotovo' THEN 1 ELSE 0 END) AS done_count,
    SUM(CASE WHEN status='Zrušeno' THEN 1 ELSE 0 END) AS cancel_count
  FROM orders
")->fetch();

$revenue = $pdo->query("
  SELECT COALESCE(SUM(COALESCE(x.sum_items,0) - discount_czk),0) AS rev
  FROM orders o
  LEFT JOIN (
    SELECT order_id, SUM(qty*unit_price_czk) AS sum_items
    FROM order_items GROUP BY order_id
  ) x ON x.order_id=o.id
  WHERE o.status <> 'Zrušeno'
")->fetch();

$upcomingStmt = $pdo->query("
  SELECT o.id, o.title, c.name AS client_name, o.end_date, o.flooring_type
  FROM orders o
  JOIN clients c ON c.id=o.client_id
  WHERE o.end_date IS NOT NULL AND o.status <> 'Zrušeno'
  ORDER BY o.end_date ASC
  LIMIT 1
");
$upcoming = $upcomingStmt->fetch();
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Dashboard – Podlahářství</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
  <header class="topbar">
    <div class="brand">
      <div class="logo">🧱</div>
      <div>
        <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Dashboard</div>
        <div class="brand-sub">Přihlášen: <?=h($u["name"])?> (<?=h($u["role"])?>)</div>
      </div>
    </div>
    <nav class="nav">
      <a class="active" href="dashboard.php">Dashboard</a>
      <a href="orders.php">Zakázky</a>
      <a href="calendar.php">Kalendář</a>
      <a href="logout.php">Odhlásit</a>
    </nav>
  </header>

  <main class="container">
    <section class="cards">
      <div class="card">
        <div class="label">Zakázky celkem</div>
        <div class="value"><?= (int)$stats["total"] ?></div>
        <div class="sub">v databázi</div>
      </div>
      <div class="card">
        <div class="label">V běhu</div>
        <div class="value"><?= (int)$stats["run_count"] ?></div>
        <div class="sub">realizace</div>
      </div>
      <div class="card">
        <div class="label">Čeká</div>
        <div class="value"><?= (int)$stats["wait_count"] ?></div>
        <div class="sub">domluvit termín/materiál</div>
      </div>
      <div class="card">
        <div class="label">Hotovo</div>
        <div class="value"><?= (int)$stats["done_count"] ?></div>
        <div class="sub">dokončeno</div>
      </div>
      <div class="card">
        <div class="label">Obrat (bez zrušených)</div>
        <div class="value"><?= czk((int)$revenue["rev"]) ?></div>
        <div class="sub">
          Nejbližší: <?= $upcoming ? ("#".(int)$upcoming["id"]." • ".h($upcoming["client_name"])." • ".$upcoming["end_date"]) : "—" ?>
        </div>
      </div>
    </section>

    <section class="panel">
      <div class="panel-head">
        <h2>Rychlé akce</h2>
        <div class="right">
          <a class="btn btn-primary" href="order_edit.php">+ Nová zakázka</a>
          <a class="btn" href="orders.php">Seznam zakázek</a>
          <a class="btn" href="calendar.php">Týdenní kalendář</a>
        </div>
      </div>
      <div class="panel-body muted">
        Offline režim: data se ukládají do <code>app/data/app.sqlite</code>. Záloha = zkopíruj soubor.
      </div>
    </section>
  </main>
</body>
</html>
