<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user();

$week = $_GET["week"] ?? ""; // ISO week "2026-W02"
$today = new DateTimeImmutable("now");

if ($week) {
  $dt = DateTimeImmutable::createFromFormat("o-\WW", $week) ?: $today;
} else {
  $dt = $today;
}

$start = $dt->setISODate((int)$dt->format("o"), (int)$dt->format("W"), 1)->setTime(0,0);
$days = [];
for ($i=0;$i<7;$i++) $days[] = $start->modify("+$i day");
$end = $start->modify("+6 day");

$pdo = db();
$stmt = $pdo->prepare("
  SELECT o.id, o.title, o.address, o.status, o.start_date, o.end_date, o.flooring_type, o.area_m2,
         c.name AS client_name, u.name AS assigned_name
  FROM orders o
  JOIN clients c ON c.id=o.client_id
  LEFT JOIN users u ON u.id=o.assigned_user_id
  WHERE
    (o.start_date IS NOT NULL AND o.end_date IS NOT NULL)
    AND o.end_date >= ? AND o.start_date <= ?
    AND o.status <> 'Zrušeno'
  ORDER BY o.start_date ASC
");
$stmt->execute([$start->format("Y-m-d"), $end->format("Y-m-d")]);
$orders = $stmt->fetchAll();

function dotClass(string $status): string {
  return match($status) {
    "Čeká" => "wait",
    "V běhu" => "run",
    "Hotovo" => "done",
    "Zrušeno" => "cancel",
    default => "run"
  };
}

$prevWeek = $start->modify("-7 day")->format("o-\WW");
$nextWeek = $start->modify("+7 day")->format("o-\WW");
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Kalendář – Podlahářství</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
<header class="topbar">
  <div class="brand">
    <div class="logo">🗓️</div>
    <div>
      <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Kalendář</div>
      <div class="brand-sub">Týden <?=h($start->format("d.m."))?> – <?=h($end->format("d.m.Y"))?></div>
    </div>
  </div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a href="orders.php">Zakázky</a>
    <a class="active" href="calendar.php">Kalendář</a>
    <a href="logout.php">Odhlásit</a>
  </nav>
</header>

<main class="container">
  <section class="panel">
    <div class="panel-head">
      <h2>Týdenní plán</h2>
      <div class="right">
        <a class="btn" href="calendar.php?week=<?=$prevWeek?>">← Minulý týden</a>
        <a class="btn" href="calendar.php">Dnes</a>
        <a class="btn" href="calendar.php?week=<?=$nextWeek?>">Další týden →</a>
      </div>
    </div>
    <div class="panel-body">
      <div class="table-wrap">
        <table class="table">
          <thead>
            <tr>
              <th>Den</th>
              <th>Zakázky v rozsahu dne</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($days as $d): ?>
              <?php
                $dStr = $d->format("Y-m-d");
                $dayOrders = array_values(array_filter($orders, fn($o) => $o["start_date"] <= $dStr && $o["end_date"] >= $dStr));
              ?>
              <tr>
                <td>
                  <strong><?=h($d->format("D"))?></strong><div class="muted"><?=h($d->format("d.m.Y"))?></div>
                </td>
                <td>
                  <?php if (!$dayOrders): ?>
                    <div class="muted">—</div>
                  <?php else: ?>
                    <div style="display:flex;flex-direction:column;gap:10px">
                      <?php foreach ($dayOrders as $o): ?>
                        <div class="notice">
                          <div style="display:flex;gap:10px;align-items:center;justify-content:space-between;flex-wrap:wrap">
                            <div>
                              <span class="badge"><span class="dot <?=dotClass($o["status"])?>"></span><?=h($o["status"])?></span>
                              <strong style="margin-left:8px">#<?= (int)$o["id"] ?> <?=h($o["client_name"])?> – <?=h($o["title"])?></strong>
                              <div class="muted"><?=h($o["address"])?> • <?=h($o["flooring_type"])?> • <?=h((string)$o["area_m2"])?> m²</div>
                              <div class="muted"><?=h($o["start_date"])?> → <?=h($o["end_date"])?> • Montér: <?=h($o["assigned_name"] ?? "—")?></div>
                            </div>
                            <div class="right">
                              <a class="btn" href="order_view.php?id=<?=(int)$o["id"]?>">Detail</a>
                              <a class="btn" href="print.php?id=<?=(int)$o["id"]?>&doc=zakazka" target="_blank">Tisk</a>
                            </div>
                          </div>
                        </div>
                      <?php endforeach; ?>
                    </div>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</main>
</body>
</html>
