<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/db.php";
require_login();

header("Content-Type: application/json; charset=utf-8");

$body = json_decode(file_get_contents("php://input"), true) ?: [];
$action = $_GET["action"] ?? "";

try {
  if ($action === "set_status") {
    $id = (int)($body["id"] ?? 0);
    $status = (string)($body["status"] ?? "");
    if ($id<=0 || $status==="") { http_response_code(400); echo json_encode(["ok"=>false]); exit; }

    $st = db()->prepare("UPDATE orders SET status=? WHERE id=?");
    $st->execute([$status, $id]);
    echo json_encode(["ok"=>true]);
    exit;
  }

  http_response_code(404);
  echo json_encode(["ok"=>false, "error"=>"Unknown action"]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(["ok"=>false, "error"=>"Server error"]);
}
