<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user();

$pdo = db();

$q = trim($_GET["q"] ?? "");
$kind = trim($_GET["kind"] ?? "");
$activeOnly = ($_GET["active"] ?? "1") === "1";

$sql = "SELECT * FROM price_list WHERE 1=1";
$params = [];

if ($activeOnly) { $sql .= " AND is_active=1"; }
if ($kind !== "") { $sql .= " AND kind=?"; $params[] = $kind; }
if ($q !== "") { $sql .= " AND (name LIKE ? OR note LIKE ? OR unit LIKE ?)"; $like="%$q%"; $params += [$like,$like,$like]; }

$sql .= " ORDER BY kind ASC, name ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Ceník – Podlahářství</title>
  <link rel="stylesheet" href="assets/style.css" />
  <script src="assets/app.js"></script>
</head>
<body>
<header class="topbar">
  <div class="brand">
    <div class="logo">💰</div>
    <div>
      <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Ceník</div>
      <div class="brand-sub">Přihlášen: <?=h($u["name"])?> (<?=h($u["role"])?>)</div>
    </div>
  </div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a href="orders.php">Zakázky</a>
    <a href="calendar.php">Kalendář</a>
    <a class="active" href="pricelist.php">Ceník</a>
    <a href="logout.php">Odhlásit</a>
  </nav>
</header>

<main class="container">
  <section class="panel">
    <div class="panel-head">
      <h2>Položky ceníku</h2>
      <div class="right">
        <button class="btn btn-primary" id="btnAdd">+ Nová položka</button>
      </div>
    </div>
    <div class="panel-body">
      <form method="get" class="grid" style="margin-bottom:12px">
        <label class="field span-2">
          <span class="muted">Hledat</span>
          <input class="input" name="q" value="<?=h($q)?>" placeholder="název, poznámka…" />
        </label>
        <label class="field">
          <span class="muted">Druh</span>
          <select class="input" name="kind">
            <option value="">Vše</option>
            <?php foreach (["Materiál","Práce","Doprava","Ostatní"] as $k): ?>
              <option value="<?=h($k)?>" <?= $kind===$k?"selected":"" ?>><?=h($k)?></option>
            <?php endforeach; ?>
          </select>
        </label>
        <label class="field">
          <span class="muted">Zobrazit</span>
          <select class="input" name="active">
            <option value="1" <?= $activeOnly?"selected":"" ?>>Jen aktivní</option>
            <option value="0" <?= !$activeOnly?"selected":"" ?>>Vše (včetně neaktivních)</option>
          </select>
        </label>
        <div class="field">
          <span class="muted">&nbsp;</span>
          <button class="btn" type="submit">Filtrovat</button>
        </div>
      </form>

      <div class="notice" style="margin-bottom:12px">
        Tip: ceny upravíš přímo v tabulce a klikneš <strong>Uložit</strong>. Neaktivní položky se neschovají, když přepneš filtr.
      </div>

      <div class="table-wrap">
        <table class="table" id="priceTable">
          <thead>
            <tr>
              <th>Druh</th>
              <th>Název</th>
              <th>MJ</th>
              <th>Cena/MJ (CZK)</th>
              <th>Poznámka</th>
              <th>Aktivní</th>
              <th>Akce</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr data-id="<?=(int)$r["id"]?>">
                <td>
                  <select class="input" data-field="kind" style="padding:8px 10px">
                    <?php foreach (["Materiál","Práce","Doprava","Ostatní"] as $k): ?>
                      <option <?= $r["kind"]===$k?"selected":"" ?>><?=h($k)?></option>
                    <?php endforeach; ?>
                  </select>
                </td>
                <td><input class="input" data-field="name" value="<?=h($r["name"])?>" /></td>
                <td><input class="input" data-field="unit" value="<?=h($r["unit"])?>" style="max-width:110px" /></td>
                <td><input class="input" data-field="unit_price_czk" type="number" step="1" min="0" value="<?=h((string)$r["unit_price_czk"])?>" style="max-width:160px" /></td>
                <td><input class="input" data-field="note" value="<?=h($r["note"] ?? "")?>" /></td>
                <td style="text-align:center">
                  <input data-field="is_active" type="checkbox" <?= (int)$r["is_active"]===1 ? "checked":"" ?> />
                </td>
                <td class="right">
                  <button class="btn btn-primary btnSave" type="button">Uložit</button>
                  <button class="btn btn-danger btnDelete" type="button">Smazat</button>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

    </div>
  </section>
</main>

<script>
(function(){
  const table = document.getElementById('priceTable');
  const btnAdd = document.getElementById('btnAdd');

  function rowPayload(tr){
    const get = (sel) => tr.querySelector(sel);
    const payload = {
      id: Number(tr.getAttribute('data-id')) || 0,
      kind: get('[data-field="kind"]').value,
      name: get('[data-field="name"]').value.trim(),
      unit: get('[data-field="unit"]').value.trim() || "ks",
      unit_price_czk: Number(get('[data-field="unit_price_czk"]').value || 0),
      note: get('[data-field="note"]').value.trim(),
      is_active: get('[data-field="is_active"]').checked ? 1 : 0
    };
    return payload;
  }

  async function saveRow(tr){
    const payload = rowPayload(tr);
    if (!payload.name){ alert('Vyplň název.'); return; }
    const res = await postJSON('api.php?action=pricelist_upsert', payload);
    if (!res.ok) { alert('Uložení se nepovedlo'); return; }
    if (res.id) tr.setAttribute('data-id', res.id);
    location.reload();
  }

  async function deleteRow(tr){
    const id = Number(tr.getAttribute('data-id') || 0);
    if (!id){ tr.remove(); return; }
    if (!confirm('Smazat položku z ceníku?')) return;
    const res = await postJSON('api.php?action=pricelist_delete', {id});
    if (!res.ok) { alert('Smazání se nepovedlo'); return; }
    location.reload();
  }

  table.addEventListener('click', (e)=>{
    const tr = e.target.closest('tr[data-id]');
    if (!tr) return;
    if (e.target.classList.contains('btnSave')) saveRow(tr);
    if (e.target.classList.contains('btnDelete')) deleteRow(tr);
  });

  btnAdd.addEventListener('click', ()=>{
    const tbody = table.querySelector('tbody');
    const tr = document.createElement('tr');
    tr.setAttribute('data-id', '0');
    tr.innerHTML = `
      <td>
        <select class="input" data-field="kind" style="padding:8px 10px">
          <option>Materiál</option><option>Práce</option><option>Doprava</option><option>Ostatní</option>
        </select>
      </td>
      <td><input class="input" data-field="name" value="" placeholder="Název položky" /></td>
      <td><input class="input" data-field="unit" value="ks" style="max-width:110px" /></td>
      <td><input class="input" data-field="unit_price_czk" type="number" step="1" min="0" value="0" style="max-width:160px" /></td>
      <td><input class="input" data-field="note" value="" placeholder="Poznámka" /></td>
      <td style="text-align:center"><input data-field="is_active" type="checkbox" checked /></td>
      <td class="right">
        <button class="btn btn-primary btnSave" type="button">Uložit</button>
        <button class="btn btn-danger btnDelete" type="button">Smazat</button>
      </td>
    `;
    tbody.prepend(tr);
    tr.querySelector('[data-field="name"]').focus();
  });
})();
</script>
</body>
</html>
