<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/db.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

header("Content-Type: application/json; charset=utf-8");

$body = json_decode(file_get_contents("php://input"), true) ?: [];
$action = $_GET["action"] ?? "";

try {
  // --- Orders status ---
  if ($action === "set_status") {
    $id = (int)($body["id"] ?? 0);
    $status = (string)($body["status"] ?? "");
    if ($id<=0 || $status==="") { http_response_code(400); echo json_encode(["ok"=>false]); exit; }

    $st = db()->prepare("UPDATE orders SET status=? WHERE id=?");
    $st->execute([$status, $id]);
    echo json_encode(["ok"=>true]);
    exit;
  }

  // --- Add order item (AJAX) ---
  if ($action === "orderitem_add") {
    $pdo = db();
    $orderId = (int)($body["order_id"] ?? 0);
    $kind = trim((string)($body["kind"] ?? "Materiál"));
    $name = trim((string)($body["name"] ?? ""));
    $unit = trim((string)($body["unit"] ?? "ks"));
    $qty = (float)($body["qty"] ?? 1);
    $price = (int)($body["unit_price_czk"] ?? 0);
    $note = trim((string)($body["note"] ?? ""));

    if ($orderId<=0 || $name==="") { http_response_code(400); echo json_encode(["ok"=>false]); exit; }
    if ($qty<=0) $qty = 1;

    $st = $pdo->prepare("INSERT INTO order_items (order_id,kind,name,unit,qty,unit_price_czk,note) VALUES (?,?,?,?,?,?,?)");
    $st->execute([$orderId,$kind,$name,$unit,$qty,$price,$note]);
    $id = (int)$pdo->lastInsertId();

    $item = $pdo->prepare("SELECT * FROM order_items WHERE id=?");
    $item->execute([$id]);
    $it = $item->fetch();

    $tot = order_totals($orderId);
    echo json_encode(["ok"=>true, "item"=>$it, "totals"=>$tot]);
    exit;
  }

  // --- Delete order item (AJAX) ---
  if ($action === "orderitem_delete") {
    $pdo = db();
    $id = (int)($body["id"] ?? 0);
    $orderId = (int)($body["order_id"] ?? 0);
    if ($id<=0 || $orderId<=0) { http_response_code(400); echo json_encode(["ok"=>false]); exit; }

    $st = $pdo->prepare("DELETE FROM order_items WHERE id=? AND order_id=?");
    $st->execute([$id,$orderId]);

    $tot = order_totals($orderId);
    echo json_encode(["ok"=>true, "totals"=>$tot]);
    exit;
  }

  // --- Pricelist ---
  if ($action === "pricelist_upsert") {
    $pdo = db();
    $id = (int)($body["id"] ?? 0);
    $kind = trim((string)($body["kind"] ?? "Materiál"));
    $name = trim((string)($body["name"] ?? ""));
    $unit = trim((string)($body["unit"] ?? "ks"));
    $price = (int)($body["unit_price_czk"] ?? 0);
    $note = trim((string)($body["note"] ?? ""));
    $isActive = (int)($body["is_active"] ?? 1);

    if ($name === "") { http_response_code(400); echo json_encode(["ok"=>false, "error"=>"missing_name"]); exit; }

    if ($id > 0) {
      $st = $pdo->prepare("UPDATE price_list SET kind=?, name=?, unit=?, unit_price_czk=?, note=?, is_active=? WHERE id=?");
      $st->execute([$kind,$name,$unit,$price,$note,$isActive,$id]);
      echo json_encode(["ok"=>true, "id"=>$id]);
      exit;
    } else {
      $st = $pdo->prepare("INSERT INTO price_list (kind,name,unit,unit_price_czk,note,is_active) VALUES (?,?,?,?,?,?)");
      $st->execute([$kind,$name,$unit,$price,$note,$isActive]);
      echo json_encode(["ok"=>true, "id"=>(int)$pdo->lastInsertId()]);
      exit;
    }
  }

  if ($action === "pricelist_delete") {
    $pdo = db();
    $id = (int)($body["id"] ?? 0);
    if ($id<=0) { http_response_code(400); echo json_encode(["ok"=>false]); exit; }
    $st = $pdo->prepare("DELETE FROM price_list WHERE id=?");
    $st->execute([$id]);
    echo json_encode(["ok"=>true]);
    exit;
  }

  http_response_code(404);
  echo json_encode(["ok"=>false, "error"=>"Unknown action"]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(["ok"=>false, "error"=>"Server error"]);
}
