<?php
require_once __DIR__ . "/../src/init.php";
ensure_schema();

require_once __DIR__ . "/../src/auth.php";
require_once __DIR__ . "/../src/helpers.php";
require_login();

$cfg = require __DIR__ . "/../src/config.php";
$u = current_user();

$id = (int)($_GET["id"] ?? 0);
if ($id>0) require_order_access($id);
$pdo = db();

$stmt = $pdo->prepare("
  SELECT o.*, 
         c.name AS client_name, c.phone AS client_phone, c.email AS client_email, c.address AS client_address,
         u.name AS assigned_name
  FROM orders o
  JOIN clients c ON c.id=o.client_id
  LEFT JOIN users u ON u.id=o.assigned_user_id
  WHERE o.id=?
");
$stmt->execute([$id]);
$row = $stmt->fetch();
if (!$row) { http_response_code(404); exit("Zakázka nenalezena"); }

// Foto upload (offline)
$uploadBase = __DIR__ . "/../data/uploads";
$orderDir = $uploadBase . "/order_" . $id;
$webDir = "../data/uploads/order_" . $id;
if (!is_dir($orderDir)) { @mkdir($orderDir, 0775, true); }

$uploadMsg = "";
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["upload_photos"])) {
  if (!empty($_FILES["photos"]["name"][0])) {
    $allowed = ["image/jpeg","image/png","image/webp"];
    for ($i=0; $i<count($_FILES["photos"]["name"]); $i++) {
      $tmp = $_FILES["photos"]["tmp_name"][$i];
      if (!$tmp) continue;
      $type = $_FILES["photos"]["type"][$i] ?? "";
      if (!in_array($type, $allowed, true)) continue;
      $name = basename($_FILES["photos"]["name"][$i]);
      $safe = preg_replace("/[^a-zA-Z0-9._-]/", "_", $name);
      $target = $orderDir . "/" . date("Ymd_His") . "_" . $safe;
      @move_uploaded_file($tmp, $target);
    }
    $uploadMsg = "Fotky nahrány.";
  }
}

$photos = [];
if (is_dir($orderDir)) {
  foreach (scandir($orderDir) as $f) {
    if ($f === "." || $f === "..") continue;
    if (!preg_match("/\.(jpe?g|png|webp)$/i", $f)) continue;
    $photos[] = $webDir . "/" . rawurlencode($f);
  }
}


$items = $pdo->prepare("SELECT * FROM order_items WHERE order_id=? ORDER BY kind, id");
$items->execute([$id]);
$items = $items->fetchAll();

$tot = order_totals($id);

$dot = match($row["status"]) {
  "Čeká" => "wait",
  "V běhu" => "run",
  "Hotovo" => "done",
  "Zrušeno" => "cancel",
  default => "run"
};
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Zakázka #<?=$id?> – Podlahářství</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
<header class="topbar">
  <div class="brand">
    <div class="logo">🧱</div>
    <div>
      <div class="brand-title"><?=h($cfg["app"]["company_name"])?> – Zakázka #<?=$id?></div>
      <div class="brand-sub">Přihlášen: <?=h($u["name"])?> (<?=h($u["role"])?>)</div>
    </div>
  </div>
  <nav class="nav">
    <a href="dashboard.php">Dashboard</a>
    <a class="active" href="orders.php">Zakázky</a>
    <a href="calendar.php">Kalendář</a>
    <a href="clients.php">Klienti</a>
    <a href="pricelist.php">Ceník</a>
      <a href="logout.php">Odhlásit</a>
  </nav>
</header>

<main class="container">
  <section class="panel">
    <div class="panel-head">
      <h2><?=h($row["title"])?></h2>
      <div class="right">
        <span class="badge"><span class="dot <?=$dot?>"></span><?=h($row["status"])?></span>
        <a class="btn" href="order_edit.php?id=<?=$id?>">Upravit</a>
        <a class="btn" href="print.php?id=<?=$id?>&doc=nabidka" target="_blank">Tisk nabídky</a>
      </div>
    </div>
    <div class="panel-body">
      <div class="grid">
        <div>
          <div class="muted">Klient</div>
          <div><strong><?=h($row["client_name"])?></strong></div>
          <div class="muted"><?=h($row["client_phone"] ?? "")?> <?= $row["client_email"] ? "• ".h($row["client_email"]) : "" ?></div>
        </div>
        <div>
          <div class="muted">Montér</div>
          <div><strong><?=h($row["assigned_name"] ?? "—")?></strong></div>
          <div class="muted">Typ: <?=h($row["flooring_type"])?> • m²: <?=h((string)$row["area_m2"])?></div>
        </div>

        <div class="span-2">
          <div class="muted">Realizační adresa</div>
          <div><strong><?=h($row["address"])?></strong></div>
        </div>

        <div>
          <div class="muted">Termín</div>
          <div><strong><?=h((string)($row["start_date"] ?? "—"))?> → <?=h((string)($row["end_date"] ?? "—"))?></strong></div>
        </div>
        <div>
          <div class="muted">Rozpočet</div>
          <div><strong><?=czk((int)round($tot["total"]))?></strong></div>
          <div class="muted">Mezisoučet <?=czk((int)$tot["subtotal"])?> • DPH <?=h((string)$tot["vat_rate"])?>%</div>
        </div>

        <div class="span-2">
          <div class="muted">Poznámka</div>
          <div><?= nl2br(h($row["note"] ?? "")) ?></div>
        </div>
      </div>
    </div>
  </section>

  <section class="panel">
    <div class="panel-head">
      <h2>Fotodokumentace</h2>
      <div class="right muted"><?= count($photos) ?> souborů</div>
    </div>
    <div class="panel-body">
      <?php if ($uploadMsg): ?><div class="notice good"><?=h($uploadMsg)?></div><?php endif; ?>
      <form method="post" enctype="multipart/form-data" class="grid" style="margin-bottom:12px">
        <label class="field span-2">
          <span class="muted">Přidat fotky (JPG/PNG/WEBP)</span>
          <input class="input" type="file" name="photos[]" multiple accept=".jpg,.jpeg,.png,.webp" />
        </label>
        <div class="field">
          <span class="muted">&nbsp;</span>
          <button class="btn btn-primary" type="submit" name="upload_photos" value="1">Nahrát</button>
        </div>
      </form>

      <?php if (!$photos): ?>
        <div class="muted">Zatím bez fotek.</div>
      <?php else: ?>
        <div style="display:grid;grid-template-columns:repeat(auto-fill,minmax(160px,1fr));gap:10px">
          <?php foreach ($photos as $p): ?>
            <a href="<?=h($p)?>" target="_blank" class="card" style="padding:10px;text-decoration:none">
              <img src="<?=h($p)?>" alt="foto" style="width:100%;height:140px;object-fit:cover;border-radius:14px;border:1px solid rgba(255,255,255,.10)" />
              <div class="muted" style="margin-top:8px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis"><?=h(basename(urldecode($p)))?></div>
            </a>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </section>

  <section class="panel">
    <div class="panel-head">
      <h2>Položky rozpočtu</h2>
      <div class="right">
        <a class="btn btn-primary" href="order_edit.php?id=<?=$id?>">+ Přidat položky</a>
      </div>
    </div>
    <div class="panel-body">
      <div class="table-wrap">
        <table class="table">
          <thead>
            <tr><th>Druh</th><th>Název</th><th>MJ</th><th>Množství</th><th>Cena/MJ</th><th>Řádek</th></tr>
          </thead>
          <tbody>
            <?php foreach ($items as $it): ?>
              <?php $sum = (float)$it["qty"]*(int)$it["unit_price_czk"]; ?>
              <tr>
                <td><?=h($it["kind"])?></td>
                <td><strong><?=h($it["name"])?></strong><div class="muted"><?=h($it["note"] ?? "")?></div></td>
                <td><?=h($it["unit"])?></td>
                <td><?=h((string)$it["qty"])?></td>
                <td><?=czk((int)$it["unit_price_czk"])?></td>
                <td><?=czk((int)round($sum))?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <div class="right" style="margin-top:12px">
        <div class="notice">
          <div><strong>Souhrn</strong></div>
          <div class="muted">Mezisoučet: <?=czk((int)$tot["subtotal"])?> • Sleva: <?=czk((int)$tot["discount"])?> • DPH: <?=czk((int)round($tot["vat"]))?></div>
          <div><strong>Celkem: <?=czk((int)round($tot["total"]))?></strong></div>
        </div>
      </div>
    </div>
  </section>
</main>
</body>
</html>
