<?php
require_once __DIR__ . '/auth.php';
if (mq_is_authed()) { header('Location: index.php'); exit; }

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pw = $_POST['password'] ?? '';
  if (mq_login($pw)) {
    header('Location: index.php');
    exit;
  } else {
    $error = 'Špatné heslo.';
  }
}
?><!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover" />
  <title>Přihlášení • Galerie</title>
  <link rel="stylesheet" href="assets/css/style.css" />
  <style>
    .login-wrap{min-height:100vh;display:grid;place-items:center;padding:18px}
    .login-card{width:min(520px, 100%);border-radius:22px;border:1px solid rgba(255,255,255,0.16);
      background: rgba(12,15,26,0.88);backdrop-filter: blur(18px);box-shadow: var(--shadow);padding:18px}
    .login-title{font-size:20px;font-weight:900;margin:6px 0 12px}
    .login-sub{color:var(--muted);font-size:13px;margin-bottom:16px}
    .error{margin-top:10px;color:#ffb4b4}
  </style>
</head>
<body>
  <div class="login-wrap">
    <form class="login-card" method="post" autocomplete="off">
      <div class="brand" style="margin-bottom:8px">
        <div class="logo" aria-hidden="true">MQ</div>
        <div class="titles">
          <div class="h1">Soukromá galerie</div>
          <div class="sub">Přístup jen pro tebe • Meta Quest</div>
        </div>
      </div>

      <div class="login-title">Zadej heslo</div>
      <div class="login-sub">Výchozí heslo je <code>123456</code> (změna v <code>config.php</code>).</div>

      <div class="control">
        <label for="password">Heslo</label>
        <input id="password" name="password" type="password" required autofocus />
      </div>

      <div style="display:flex;gap:10px;align-items:center;margin-top:12px">
        <button class="btn" type="submit">Přihlásit</button>
      </div>

      <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
      <?php endif; ?>
    </form>
  </div>
</body>
</html>
