<?php
require_once __DIR__ . '/auth.php';
mq_require_auth();
?><!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover" />
  <title>Galerie (Meta Quest)</title>
  <link rel="stylesheet" href="assets/css/style.css" />
</head>
<body>
  <header class="topbar">
    <div class="brand">
      <div class="logo" aria-hidden="true">MQ</div>
      <div class="titles">
        <div class="h1">Galerie</div>
        <div class="sub">Filtrování • Třídění • Fullscreen • VR • Video</div>
      </div>
      <div style="margin-left:auto;display:flex;gap:10px;align-items:center">
        <a class="btn" href="vr.php" title="Spustit VR režim (WebXR)">VR režim</a>
        <a class="btn btn-ghost" href="logout.php" title="Odhlásit">Odhlásit</a>
      </div>
    </div>

    <div class="controls">
      <div class="control">
        <label for="q">Hledat</label>
        <input id="q" type="search" placeholder="název, tag…" autocomplete="off" />
      </div>

      <div class="control">
        <label for="category">Kategorie</label>
        <select id="category">
          <option value="">Vše</option>
        </select>
      </div>

      <div class="control">
        <label for="sort">Třídit / filtrovat</label>
        <select id="sort">
          <option value="date_desc">Nejnovější</option>
          <option value="date_asc">Nejstarší</option>
          <option value="name_asc">Název A→Z</option>
          <option value="name_desc">Název Z→A</option>
          <option value="size_desc">Největší soubory</option>
          <option value="size_asc">Nejmenší soubory</option>
          <option value="rating_desc">Hodnocení ↓</option>
          <option value="rating_asc">Hodnocení ↑</option>
          <option value="type_videos">Jen videa</option>
          <option value="type_images">Jen fotky</option>
        </select>
      </div>

      <div class="control control-inline">
        <label class="chip">
          <input id="favoritesOnly" type="checkbox" />
          <span>Jen ★</span>
        </label>

        <button id="reset" class="btn" type="button">Reset</button>
      </div>
    </div>
  </header>

  <main class="wrap">
    <div class="status">
      <div id="count">Načítám…</div>
      <div class="hint">Soubory dávej do <code>/media</code> (foto + video).</div>
    </div>

    <section id="grid" class="grid" aria-live="polite"></section>
  </main>

  <div id="viewer" class="viewer" aria-hidden="true">
    <div class="viewer-backdrop" data-close></div>
    <div class="viewer-card" role="dialog" aria-modal="true" aria-label="Prohlížeč">
      <div class="viewer-top">
        <div class="viewer-title">
          <div id="viewerName" class="viewer-name">—</div>
          <div id="viewerMeta" class="viewer-meta">—</div>
        </div>
        <div class="viewer-actions">
          <button id="fsBtn" class="btn btn-ghost" type="button" title="Fullscreen">⤢</button>
          <button id="favBtn" class="btn btn-ghost" type="button" title="Oblíbené">★</button>
          <button class="btn btn-ghost" type="button" data-close title="Zavřít">✕</button>
        </div>
      </div>
      <div class="viewer-body">
        <button id="prev" class="navbtn" type="button" aria-label="Předchozí">‹</button>
        <div class="viewer-media">
          <img id="viewerImg" alt="" style="display:none" />
          <video id="viewerVid" style="display:none" playsinline controls></video>
        </div>
        <button id="next" class="navbtn" type="button" aria-label="Další">›</button>
      </div>
      <div class="viewer-bottom">
        <div class="kbd">
          <span>Ovládání:</span>
          <span class="kbdkey">←</span><span class="kbdkey">→</span>
          <span class="kbdkey">Esc</span>
        </div>
      </div>
    </div>
  </div>

  <script src="assets/js/app.js"></script>
</body>
</html>
