<?php
require_once __DIR__ . '/config.php';
session_start();

function mq_is_authed(): bool {
  return isset($_SESSION[MQ_SESSION_KEY]) && $_SESSION[MQ_SESSION_KEY] === true;
}
function mq_require_auth() {
  if (!mq_is_authed()) {
    header('Location: login.php');
    exit;
  }
}
function mq_login(string $password): bool {
  $hash = hash('sha256', $password);
  if (hash_equals(MQ_PASSWORD_SHA256, $hash)) {
    $_SESSION[MQ_SESSION_KEY] = true;
    return true;
  }
  return false;
}
function mq_logout() {
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params['path'], $params['domain'], $params['secure'], $params['httponly']
    );
  }
  session_destroy();
}
?>