/* MQ Gallery PRO: image+video, filtering, sorting, favorites, fullscreen */
const $ = (s)=>document.querySelector(s);
const els={q:$('#q'),category:$('#category'),sort:$('#sort'),favoritesOnly:$('#favoritesOnly'),reset:$('#reset'),
grid:$('#grid'),count:$('#count'),viewer:$('#viewer'),viewerImg:$('#viewerImg'),viewerVid:$('#viewerVid'),
viewerName:$('#viewerName'),viewerMeta:$('#viewerMeta'),prev:$('#prev'),next:$('#next'),favBtn:$('#favBtn'),fsBtn:$('#fsBtn')};
let all=[], filtered=[], activeIndex=-1;
const LS='mq_gallery_favorites_v1';
const getFavs=()=>{try{return JSON.parse(localStorage.getItem(LS)||'[]')}catch{return[]}};
const setFavs=(a)=>localStorage.setItem(LS,JSON.stringify(a));
const isFav=(f)=>getFavs().includes(f);
const toggleFav=(f)=>{const s=new Set(getFavs());s.has(f)?s.delete(f):s.add(f);setFavs([...s]);};

const fmtBytes=(b)=>{if(!Number.isFinite(b))return'—';const u=['B','KB','MB','GB'];let i=0,n=b;while(n>=1024&&i<u.length-1){n/=1024;i++;}return `${n.toFixed(i===0?0:1)} ${u[i]}`;}
const fmtDate=(ts)=>{if(!Number.isFinite(ts))return'—';return new Date(ts*1000).toLocaleDateString('cs-CZ',{year:'numeric',month:'2-digit',day:'2-digit'});}
const norm=(s)=>(s||'').toString().toLowerCase().trim();
const esc=(s)=>(s||'').replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m]));

function apply(){
  const q=norm(els.q.value), cat=els.category.value, favOnly=els.favoritesOnly.checked;
  filtered = all.filter(p=>{
    if(cat && p.category!==cat) return false;
    if(favOnly && !isFav(p.file)) return false;
    if(!q) return true;
    const hay=[p.title,p.file,p.category,p.type,...(p.tags||[])].map(norm).join(' ');
    return hay.includes(q);
  });

  const s=els.sort.value;
  if(s==='type_videos') filtered=filtered.filter(x=>x.type==='video');
  if(s==='type_images') filtered=filtered.filter(x=>x.type==='image');

  const cmp={
    date_desc:(a,b)=>b.mtime-a.mtime,
    date_asc:(a,b)=>a.mtime-b.mtime,
    name_asc:(a,b)=>a.displayName.localeCompare(b.displayName,'cs',{sensitivity:'base'}),
    name_desc:(a,b)=>b.displayName.localeCompare(a.displayName,'cs',{sensitivity:'base'}),
    size_desc:(a,b)=>b.size-a.size,
    size_asc:(a,b)=>a.size-b.size,
    rating_desc:(a,b)=>(b.rating||0)-(a.rating||0),
    rating_asc:(a,b)=>(a.rating||0)-(b.rating||0),
  }[s] || ((a,b)=>b.mtime-a.mtime);
  filtered.sort(cmp);
  render();
}

function render(){
  els.grid.innerHTML='';
  els.count.textContent=`${filtered.length} / ${all.length} položek`;
  const frag=document.createDocumentFragment();
  for(let i=0;i<filtered.length;i++){
    const p=filtered[i];
    const card=document.createElement('article');
    card.className='card'; card.tabIndex=0; card.setAttribute('role','button');

    let mediaEl;
    if(p.type==='video'){
      const v=document.createElement('video');
      v.className='thumb'; v.src=p.url; v.muted=true; v.playsInline=true; v.preload='metadata'; v.loop=true;
      v.addEventListener('mouseenter',()=>v.play().catch(()=>{}));
      v.addEventListener('mouseleave',()=>{try{v.pause();v.currentTime=0;}catch{}});
      mediaEl=v;
      const play=document.createElement('div'); play.className='playbadge'; play.textContent='▶'; card.appendChild(play);
    }else{
      const img=document.createElement('img');
      img.className='thumb'; img.loading='lazy'; img.src=p.url; img.alt=p.displayName;
      mediaEl=img;
    }

    const star=document.createElement('div');
    star.className='star'+(isFav(p.file)?'':' off'); star.textContent='★';
    star.addEventListener('click',(e)=>{e.stopPropagation();toggleFav(p.file);apply();});

    const meta=document.createElement('div');
    meta.className='cardmeta';
    meta.innerHTML=`
      <div>
        <div class="name">${esc(p.displayName)}</div>
        <div class="subline">${esc(p.category||'—')} • ${p.type==='video'?'video':'foto'} • ${fmtDate(p.mtime)} • ${fmtBytes(p.size)}</div>
      </div>
      <div class="badges">${p.rating?`<span class="badge">★ ${p.rating}</span>`:''}</div>
    `;

    card.appendChild(mediaEl); card.appendChild(star); card.appendChild(meta);
    card.addEventListener('click',()=>openViewer(i));
    card.addEventListener('keydown',(e)=>{if(e.key==='Enter'||e.key===' '){e.preventDefault();openViewer(i);}});
    frag.appendChild(card);
  }
  els.grid.appendChild(frag);
}

function openViewer(index){
  activeIndex=Math.max(0,Math.min(index,filtered.length-1));
  const p=filtered[activeIndex]; if(!p) return;
  els.viewer.classList.add('open'); els.viewer.setAttribute('aria-hidden','false');

  // reset
  try{els.viewerVid.pause();}catch{}
  els.viewerVid.removeAttribute('src'); els.viewerVid.load();
  els.viewerImg.style.display='none'; els.viewerVid.style.display='none';

  if(p.type==='video'){
    els.viewerVid.style.display='';
    els.viewerVid.src=p.url; els.viewerVid.load(); els.viewerVid.play().catch(()=>{});
  }else{
    els.viewerImg.style.display='';
    els.viewerImg.src=p.url; els.viewerImg.alt=p.displayName;
  }

  els.viewerName.textContent=p.displayName;
  els.viewerMeta.textContent=`${p.category||'—'} • ${p.type==='video'?'video':'foto'} • ${fmtDate(p.mtime)} • ${fmtBytes(p.size)}${p.rating?` • ★ ${p.rating}`:''}`;
  els.favBtn.textContent=isFav(p.file)?'★':'☆';
}

function closeViewer(){
  try{els.viewerVid.pause();}catch{}
  els.viewer.classList.remove('open'); els.viewer.setAttribute('aria-hidden','true');
  activeIndex=-1;
}
function step(dir){
  if(activeIndex<0) return;
  const next=(activeIndex+dir+filtered.length)%filtered.length;
  openViewer(next);
}

async function boot(){
  try{
    els.count.textContent='Načítám…';
    const res=await fetch('api/media.php',{cache:'no-store'});
    const data=await res.json();
    all=(data.items||[]).map(p=>({...p,displayName:p.title||p.file.replace(/\.[^/.]+$/,'').replace(/[_-]+/g,' ')}));
    const cats=[...new Set(all.map(p=>p.category).filter(Boolean))].sort((a,b)=>a.localeCompare(b,'cs',{sensitivity:'base'}));
    for(const c of cats){const o=document.createElement('option');o.value=c;o.textContent=c;els.category.appendChild(o);}
    apply();
  }catch(e){
    console.error(e);
    els.count.textContent='Chyba při načítání. Zkontroluj PHP server.';
  }
}

function wire(){
  const rerun=()=>apply();
  els.q.addEventListener('input',()=>{clearTimeout(els.q._t);els.q._t=setTimeout(rerun,120);});
  els.category.addEventListener('change',rerun);
  els.sort.addEventListener('change',rerun);
  els.favoritesOnly.addEventListener('change',rerun);
  els.reset.addEventListener('click',()=>{els.q.value='';els.category.value='';els.sort.value='date_desc';els.favoritesOnly.checked=false;apply();});
  document.querySelectorAll('[data-close]').forEach(el=>el.addEventListener('click',closeViewer));
  document.addEventListener('keydown',(e)=>{
    if(!els.viewer.classList.contains('open')) return;
    if(e.key==='Escape') closeViewer();
    if(e.key==='ArrowLeft') step(-1);
    if(e.key==='ArrowRight') step(+1);
  });
  els.prev.addEventListener('click',()=>step(-1));
  els.next.addEventListener('click',()=>step(+1));
  els.favBtn.addEventListener('click',()=>{if(activeIndex<0)return;toggleFav(filtered[activeIndex].file);apply();});
  els.fsBtn.addEventListener('click',async()=>{
    const target=els.viewer.querySelector('.viewer-card');
    if(!document.fullscreenElement){try{await target.requestFullscreen();}catch{}}
    else{try{await document.exitFullscreen();}catch{}}
  });
}
wire(); boot();
