<?php
require_once __DIR__ . '/../auth.php';
mq_require_auth();

header('Content-Type: application/json; charset=utf-8');

$root = dirname(__DIR__);
$dir = $root . DIRECTORY_SEPARATOR . 'media';
$metaFile = $root . DIRECTORY_SEPARATOR . 'data' . DIRECTORY_SEPARATOR . 'metadata.json';

$imgExt = ['jpg','jpeg','png','webp','gif','svg'];
$vidExt = ['mp4','webm','ogg'];

$metadata = [];
if (file_exists($metaFile)) {
  $arr = json_decode(file_get_contents($metaFile), true);
  if (is_array($arr)) foreach ($arr as $m) if (isset($m['file'])) $metadata[$m['file']] = $m;
}

$items = [];
if (is_dir($dir)) {
  foreach (scandir($dir) as $f) {
    if ($f === '.' || $f === '..') continue;
    $path = $dir . DIRECTORY_SEPARATOR . $f;
    if (!is_file($path)) continue;

    $ext = strtolower(pathinfo($f, PATHINFO_EXTENSION));
    $type = null;
    if (in_array($ext, $imgExt)) $type = 'image';
    if (in_array($ext, $vidExt)) $type = 'video';
    if (!$type) continue;

    $stat = stat($path);
    $m = $metadata[$f] ?? [];

    $category = $m['category'] ?? null;
    if (!$category) {
      $parts = explode('_', $f);
      if (count($parts) > 1) $category = $parts[0];
    }

    $url = '../media/' . rawurlencode($f);

    $thumb = null;
    if ($type === 'image') $thumb = $url;
    else {
      $base = pathinfo($f, PATHINFO_FILENAME);
      $poster = $dir . DIRECTORY_SEPARATOR . $base . '.poster.jpg';
      $thumb = file_exists($poster) ? ('../media/' . rawurlencode($base . '.poster.jpg')) : $url;
    }

    $items[] = [
      'file' => $f,
      'url' => $url,
      'thumb' => $thumb,
      'type' => $type,
      'title' => $m['title'] ?? null,
      'category' => $category,
      'tags' => $m['tags'] ?? [],
      'rating' => $m['rating'] ?? null,
      'mtime' => $stat['mtime'],
      'size' => $stat['size'],
    ];
  }
}

echo json_encode(['ok'=>true,'count'=>count($items),'items'=>$items], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
