/**
 * postinstall: runs automatically after `npm install`
 * Goal: smoother setup on shared hosting.
 *
 * - ensures /public exists
 * - creates .env from .env.example if missing
 */
import fs from "fs";
import path from "path";
import { fileURLToPath } from "url";

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
const root = path.join(__dirname, "..");

const publicDir = path.join(root, "public");
if (!fs.existsSync(publicDir)) {
  fs.mkdirSync(publicDir, { recursive: true });
  console.log("[postinstall] created public/");
}

const envPath = path.join(root, ".env");
const envExamplePath = path.join(root, ".env.example");
if (!fs.existsSync(envPath) && fs.existsSync(envExamplePath)) {
  fs.copyFileSync(envExamplePath, envPath);
  console.log("[postinstall] created .env from .env.example");
}

console.log("[postinstall] done");
