# Namecheap deploy (Node.js / cPanel)

Tahle verze je nachystaná pro Namecheap hosting s podporou **Node.js apps** (cPanel).

## Co obsahuje
- `server.js` – Express server (servíruje `/public` + API `/route`)
- `public/` – web (Leaflet mapa)
- `providers/db.js` – jízdní řády přes `v6.db.transport.rest`

## Nasazení (cPanel)
1) Nahraj a rozbal ZIP do složky (např. `train-map/`).
2) cPanel → **Setup Node.js App**
3) Vytvoř aplikaci:
   - **Application root:** `train-map` (nebo tvoje složka)
   - **Application startup file:** `server.js`
   - **Node version:** LTS
4) Klikni **Run NPM Install**
5) Klikni **Start App**

Pak otevři URL, které ti cPanel ukáže u aplikace (nebo přesměruj doménu/subdoménu podle cPanelu).

## Lokální test
- `npm install`
- `npm start`
- otevři `http://localhost:8787/`



## "Samo nainstalovalo" – co je možné na cPanel shared hostingu

Na shared hostingu se Node app **nemůže sama vytvořit** (root/startup file/Node verze nastavuje cPanel),
ale po tomhle jednorázovém kroku už instalace probíhá automaticky:

- po kliknutí **Run NPM Install** se automaticky spustí `postinstall` (v `package.json`),
  který vytvoří `.env` z `.env.example` a zkontroluje strukturu.

Typický flow:
1) Create app (jednou)
2) Upload/rozbal ZIP (kdykoliv)
3) **Run NPM Install** (při prvním nasazení / když se změní závislosti)
4) **Restart App** (po každé změně kódu)



## Doména bez portu / bez "localhost"
Frontend je nastavený na **same-origin** volání (`/route`, `/health`), takže:
- na hostingu to funguje automaticky na URL, kde běží Node app
- lokálně to funguje na `http://localhost:8787/`

### Jak to dát na hlavní doménu (root)
Na cPanel shared hostingu to typicky uděláš takhle:
1) V **Setup Node.js App** nastav **Application URL** na `/` (root) **nebo** použij subdoménu.
2) Pokud už máš na rootu klasický web, tak:
   - buď přesuneš web jinam a Node app dáš na `/`
   - nebo necháš Node app na `/train-map/` a na root dáš přesměrování (.htaccess)

### Přesměrování root → /train-map/
Když Node app běží třeba na `/train-map/`, můžeš do `public_html/.htaccess` dát:
```
RewriteEngine On
RewriteRule ^$ /train-map/ [R=302,L]
```
(302 je dočasné, až to budeš mít hotové, dej 301.)
