<?php
include 'auth.php';
include 'config.php';
include 'helpers.php';

$file = 'data.json';
if (!file_exists($file)) file_put_contents($file, '[]');
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$status = $_GET['status'] ?? 'all';
$selectedPlatforms = $_GET['platformy'] ?? [];
if (!is_array($selectedPlatforms)) $selectedPlatforms = [$selectedPlatforms];
$withImages = ($_GET['images'] ?? '0') === '1';
$filterPlatforms = count($selectedPlatforms) > 0;

$filtered = [];
foreach ($data as $d) {
  $st = norm_status($d['status'] ?? 'aktivni');
  if ($status !== 'all' && $st !== $status) continue;

  $plats = ensure_array($d['platformy'] ?? []);
  if ($filterPlatforms) {
    $ok = false;
    foreach ($plats as $p) {
      if (in_array($p, $selectedPlatforms, true)) { $ok = true; break; }
    }
    if (!$ok) continue;
  }
  $filtered[] = $d;
}

$total = 0.0;
foreach ($filtered as $d) $total += (float)($d['cena'] ?? 0);

function sel($a,$b){ return ($a===$b) ? 'selected' : ''; }
function chk($arr,$k){ return in_array($k,$arr,true) ? 'checked' : ''; }
?>
<!doctype html>
<html lang="cs">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Tiskový přehled</title>
<style>
  body{font-family:Arial;margin:16px}
  h1{margin:0 0 6px 0}
  .muted{color:#444;font-size:12px;margin:4px 0 12px 0}
  .panel{border:1px solid #ddd;border-radius:10px;padding:12px;margin-bottom:12px;background:#fafafa}
  .row{display:flex;gap:14px;flex-wrap:wrap;align-items:flex-end}
  label{font-size:12px;color:#444;display:block;margin-bottom:4px}
  select{padding:6px}
  .checks{display:flex;gap:10px;flex-wrap:wrap;align-items:center}
  .check{display:flex;gap:6px;align-items:center;font-size:13px}
  .btn{padding:8px 10px;border:1px solid #ddd;border-radius:10px;background:#fff;cursor:pointer}
  table{width:100%;border-collapse:collapse}
  td,th{border:1px solid #000;padding:6px;font-size:12px;vertical-align:top}
  .thumb{width:52px;height:52px;object-fit:cover;border:1px solid #000}
  .gallery{display:flex;gap:4px;flex-wrap:wrap}
  @media print{ .panel{display:none} body{margin:0} }
</style>
</head>
<body>

<div class="panel">
  <form method="get">
    <div class="row">
      <div>
        <label>Co tisknout (stav)</label>
        <select name="status">
          <option value="all" <?=sel($status,'all')?>>vše</option>
          <option value="aktivni" <?=sel($status,'aktivni')?>>jen aktivní</option>
          <option value="prodano" <?=sel($status,'prodano')?>>jen prodané</option>
        </select>
      </div>

      <div>
        <label>Platformy</label>
        <div class="checks">
          <?php foreach($PLATFORMS as $k=>$v): ?>
            <label class="check"><input type="checkbox" name="platformy[]" value="<?=h($k)?>" <?=chk($selectedPlatforms,$k)?>> <?=h($v)?></label>
          <?php endforeach; ?>
          <span class="muted">Když nic nezaškrtneš, vytiskne se vše.</span>
        </div>
      </div>

      <div>
        <label>Obrázky</label>
        <label class="check"><input type="checkbox" name="images" value="1" <?= $withImages ? 'checked' : '' ?>> tisknout s obrázky</label>
      </div>

      <div>
        <button class="btn" type="submit">Použít filtr</button>
        <button class="btn" type="button" onclick="window.print()">Tisk</button>
      </div>
    </div>
  </form>
</div>

<h1>Tiskový přehled inzerátů</h1>
<div class="muted">
  Vytvořeno: <?=date('Y-m-d H:i')?> |
  Počet položek: <?=count($filtered)?> |
  Součet: <?=number_format($total, 0, ',', ' ')?> Kč
</div>

<table>
  <thead>
    <tr>
      <?php if ($withImages): ?><th>Obrázky</th><?php endif; ?>
      <th>Název</th><th>Cena</th><th>Platformy</th><th>Stav</th><th>Uskladnění</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($filtered as $d):
      $st = norm_status($d['status'] ?? 'aktivni');
      $stLabel = $st === 'prodano' ? 'prodáno' : 'aktivní';
      $plats = ensure_array($d['platformy'] ?? []);
      $fotky = ensure_array($d['fotky'] ?? []);
    ?>
    <tr>
      <?php if ($withImages): ?>
      <td>
        <?php if (count($fotky) > 0): ?>
          <div class="gallery">
            <?php foreach($fotky as $f): ?>
              <?php if ($f && file_exists('uploads/'.$f)): ?>
                <img class="thumb" src="uploads/<?=h($f)?>" alt="">
              <?php endif; ?>
            <?php endforeach; ?>
          </div>
        <?php else: ?>-<?php endif; ?>
      </td>
      <?php endif; ?>
      <td><?=h($d['nazev'] ?? '')?></td>
      <td><?=number_format((float)($d['cena'] ?? 0), 0, ',', ' ')?></td>
      <td><?=h(platforms_to_string($plats))?></td>
      <td><?=$stLabel?></td>
      <td><?=h($d['poznamka'] ?? '')?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</body>
</html>
