<?php
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function norm_status($s){ return ($s === 'prodano') ? 'prodano' : 'aktivni'; }
function ensure_array($x){ return is_array($x) ? $x : []; }
function platforms_to_string($arr){ $arr = ensure_array($arr); return implode(', ', $arr); }

function safe_image_ext($name){
  $ext = strtolower(pathinfo((string)$name, PATHINFO_EXTENSION));
  return in_array($ext, ['jpg','jpeg','png','webp','gif'], true) ? $ext : '';
}

function upload_many_images($filesKey){
  $saved = [];
  if (!isset($_FILES[$filesKey])) return $saved;
  if (!is_dir('uploads')) mkdir('uploads');

  $f = $_FILES[$filesKey];
  if (!isset($f['name']) || !is_array($f['name'])) return $saved;

  for ($i=0; $i<count($f['name']); $i++){
    if (($f['error'][$i] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) continue;
    if (($f['size'][$i] ?? 0) <= 0) continue;

    $ext = safe_image_ext($f['name'][$i]);
    if (!$ext) continue;

    $name = time().'_'.bin2hex(random_bytes(4)).'.'.$ext;
    if (move_uploaded_file($f['tmp_name'][$i], 'uploads/'.$name)) $saved[] = $name;
  }
  return $saved;
}

function str_contains_ci($haystack, $needle){
  $haystack = mb_strtolower((string)$haystack, 'UTF-8');
  $needle = mb_strtolower((string)$needle, 'UTF-8');
  return $needle === '' ? true : (mb_strpos($haystack, $needle) !== false);
}

function intersects($a, $b){
  $a = ensure_array($a); $b = ensure_array($b);
  $set = [];
  foreach($a as $x) $set[(string)$x] = true;
  foreach($b as $y) if (isset($set[(string)$y])) return true;
  return false;
}
?>