<?php
include 'auth.php';
include 'helpers.php';

$file = 'data.json';
if (!file_exists($file)) file_put_contents($file, '[]');

$err = '';
$ok = '';
if ($_FILES) {
  if (!isset($_FILES['f']) || $_FILES['f']['error'] !== UPLOAD_ERR_OK) {
    $err = 'Soubor se nepodařilo nahrát.';
  } else {
    $raw = file_get_contents($_FILES['f']['tmp_name']);
    $import = json_decode($raw, true);

    if (!is_array($import)) {
      $err = 'Soubor není platný TXT export (očekávám JSON).';
    } else {
      // normalizace a základní validace
      $norm = [];
      foreach ($import as $row) {
        if (!is_array($row)) continue;
        $nazev = trim((string)($row['nazev'] ?? ''));
        if ($nazev === '') continue;

        $cena = (float)($row['cena'] ?? 0);
        $platformy = ensure_array($row['platformy'] ?? []);
        $platformy = array_values(array_filter(array_map(fn($x)=>trim((string)$x), $platformy), fn($x)=>$x!==''));
        $status = norm_status($row['status'] ?? 'aktivni');
        $fotky = ensure_array($row['fotky'] ?? []);
        $fotky = array_values(array_filter(array_map(fn($x)=>trim((string)$x), $fotky), fn($x)=>$x!==''));
        $poznamka = (string)($row['poznamka'] ?? '');

        $norm[] = [
          'nazev' => $nazev,
          'cena' => $cena,
          'platformy' => $platformy,
          'status' => $status,
          'fotky' => $fotky,
          'poznamka' => $poznamka,
        ];
      }

      $replace = isset($_POST['replace']) && $_POST['replace'] === '1';

      if ($replace) {
        $data = $norm;
      } else {
        $data = json_decode(file_get_contents($file), true);
        if (!is_array($data)) $data = [];
        $data = array_merge($data, $norm);
      }

      file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
      header('Location:index.php'); exit;
    }
  }
}
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Import</title></head><body>
<header class="topbar">
  <div>
    <h1>Import TXT</h1>
    <div class="muted small">Importuj TXT soubor vytvořený přes „Export TXT“ (je to JSON).</div>
  </div>
  <div class="actions"><a class="btn" href="index.php">Zpět</a></div>
</header>
<section class="card">
  <?php if ($err): ?><div class="alert"><?=$err?></div><?php endif; ?>
  <form method="post" enctype="multipart/form-data" class="grid">
    <div class="full">
      <label>TXT soubor (export)</label>
      <input type="file" name="f" accept=".txt,text/plain,application/json" required>
    </div>
    <div class="full">
      <label class="check"><input type="checkbox" name="replace" value="1" checked> Přepsat existující data (doporučeno pro obnovu zálohy)</label>
      <div class="muted small">Když odškrtneš, import se pouze přidá ke stávajícím položkám.</div>
    </div>
    <div class="full">
      <button class="btn primary">Importovat</button>
    </div>
  </form>
</section>
</body></html>
