<?php
include 'auth.php';

$file = 'data.json';
if (!file_exists($file)) file_put_contents($file, '[]');

$data = file_get_contents($file);
if ($data === false || trim($data) === '') $data = '[]';

// pretty print if possible
$decoded = json_decode($data, true);
if (is_array($decoded)) {
  $data = json_encode($decoded, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

$fname = 'inzeraty_export_' . date('Y-m-d') . '.txt';
header('Content-Type: text/plain; charset=utf-8');
header('Content-Disposition: attachment; filename="'.$fname.'"');
echo $data;
