<?php
include 'auth.php';
include 'config.php';
include 'helpers.php';

$file = 'data.json';
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$id = (int)($_GET['id'] ?? -1);
if ($id < 0 || $id >= count($data)) { header('Location:index.php'); exit; }

$d = $data[$id];
$platformy = ensure_array($d['platformy'] ?? []);
$fotky = ensure_array($d['fotky'] ?? []);
$st = norm_status($d['status'] ?? 'aktivni');

function checked($arr,$k){ return in_array($k,$arr,true) ? 'checked' : ''; }
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Editace</title></head><body>
<header class="topbar">
  <div><h1>Editace položky</h1></div>
  <div class="actions"><a class="btn" href="index.php">Zpět</a></div>
</header>

<section class="card">
<form id="editForm" method="post" action="update.php?id=<?=$id?>" class="grid" enctype="multipart/form-data">
  <div>
    <label>Název</label>
    <input name="nazev" value="<?=h($d['nazev'] ?? '')?>" required>
  </div>
  <div>
    <label>Cena (Kč)</label>
    <input name="cena" type="number" step="1" min="0" value="<?=h($d['cena'] ?? '')?>" required>
  </div>
  <div>
    <label>Stav</label>
    <select name="status">
      <option value="aktivni" <?=$st==='aktivni'?'selected':''?>>aktivní</option>
      <option value="prodano" <?=$st==='prodano'?'selected':''?>>prodáno</option>
    </select>
  </div>
  <div>
    <label>Platformy</label>
    <div class="checks">
      <?php foreach($PLATFORMS as $k=>$v): ?>
        <label class="check"><input type="checkbox" name="platformy[]" value="<?=h($k)?>" <?=checked($platformy,$k)?>> <?=h($v)?></label>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="full">
    <label>Interní poznámka (netiskne se)</label>
    <textarea name="poznamka" rows="3" placeholder="Pouze pro mě – nezobrazuje se v tisku"><?=h($d['poznamka'] ?? '')?></textarea>
  </div>

  <div class="full">
    <label>Aktuální galerie (zaškrtni fotky k odstranění)</label>
    <?php if (count($fotky) > 0): ?>
      <div class="gallery">
        <?php foreach($fotky as $f): ?>
          <label class="gremove">
            <input type="checkbox" name="remove_fotky[]" value="<?=h($f)?>">
            <span><img class="thumb" src="uploads/<?=h($f)?>" alt=""></span>
            <span class="muted small">smazat</span>
          </label>
        <?php endforeach; ?>
      </div>
    <?php else: ?><div class="muted small">Žádné fotky</div><?php endif; ?>
  </div>

  <div class="full">
    <label>Přidat další fotky</label>
    <input type="file" name="fotky[]" accept="image/*" multiple>
  </div>

  <div class="full">
    <button class="btn primary">Uložit změny</button>
  </div>
</form>
</section>

<script>
(function(){
  const form = document.getElementById('editForm');
  if(!form) return;
  const id = <?=json_encode($id)?>;
  const KEY = 'inzeraty_edit_draft_v1_' + id;

  function getDraft(){ try { return JSON.parse(localStorage.getItem(KEY) || 'null'); } catch(e){ return null; } }
  function setDraft(obj){ try { localStorage.setItem(KEY, JSON.stringify(obj)); } catch(e){} }
  function clearDraft(){ try { localStorage.removeItem(KEY); } catch(e){} }

  function readForm(){
    const fd = new FormData(form);
    const platformy = [];
    form.querySelectorAll('input[name="platformy[]"]:checked').forEach(cb => platformy.push(cb.value));
    const removeFotky = [];
    form.querySelectorAll('input[name="remove_fotky[]"]:checked').forEach(cb => removeFotky.push(cb.value));
    return {
      ts: Date.now(),
      nazev: (fd.get('nazev') || '').toString(),
      cena: (fd.get('cena') || '').toString(),
      status: (fd.get('status') || 'aktivni').toString(),
      platformy,
      poznamka: (fd.get('poznamka') || '').toString(),
      remove_fotky: removeFotky
    };
  }

  function applyDraft(d){
    if(!d) return;
    if(d.nazev != null) form.querySelector('input[name="nazev"]').value = d.nazev;
    if(d.cena != null) form.querySelector('input[name="cena"]').value = d.cena;
    if(d.status != null) form.querySelector('select[name="status"]').value = d.status;
    if(Array.isArray(d.platformy)){
      form.querySelectorAll('input[name="platformy[]"]').forEach(cb => cb.checked = d.platformy.includes(cb.value));
    }
    if(d.poznamka != null) form.querySelector('textarea[name="poznamka"]').value = d.poznamka;
    if(Array.isArray(d.remove_fotky)){
      form.querySelectorAll('input[name="remove_fotky[]"]').forEach(cb => cb.checked = d.remove_fotky.includes(cb.value));
    }
  }

  const d = getDraft();
  if(d && (d.nazev || d.cena || (d.platformy && d.platformy.length) || d.poznamka || (d.remove_fotky && d.remove_fotky.length))) {
    if (confirm('Najel jsem rozpracovanou editaci (automatické ukládání). Chceš ji obnovit?')) {
      applyDraft(d);
    } else {
      clearDraft();
    }
  }

  let t=null;
  function scheduleSave(){
    if(t) clearTimeout(t);
    t=setTimeout(()=>setDraft(readForm()), 200);
  }
  form.addEventListener('input', scheduleSave);
  form.addEventListener('change', scheduleSave);
  window.addEventListener('beforeunload', function(){ setDraft(readForm()); });

  form.addEventListener('submit', function(){ clearDraft(); });
})();
</script>

</body></html>
