<?php
include 'auth.php';
include 'helpers.php';

$file = 'data.json';
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$id = (int)($_GET['id'] ?? -1);
if ($id < 0 || $id >= count($data)) { header('Location:index.php'); exit; }

$oldFotky = ensure_array($data[$id]['fotky'] ?? []);

$toRemove = $_POST['remove_fotky'] ?? [];
if (!is_array($toRemove)) $toRemove = [$toRemove];
$toRemoveMap = [];
foreach($toRemove as $r){ $toRemoveMap[(string)$r] = true; }

$newFotky = [];
foreach($oldFotky as $f){
  if (isset($toRemoveMap[$f])) {
    if ($f && file_exists('uploads/'.$f)) @unlink('uploads/'.$f);
  } else {
    $newFotky[] = $f;
  }
}

$added = upload_many_images('fotky');
foreach($added as $f) $newFotky[] = $f;

$data[$id] = [
  'nazev' => trim((string)($_POST['nazev'] ?? '')),
  'cena' => (float)($_POST['cena'] ?? 0),
  'platformy' => isset($_POST['platformy']) && is_array($_POST['platformy']) ? $_POST['platformy'] : [],
  'status' => norm_status($_POST['status'] ?? 'aktivni'),
  'fotky' => $newFotky
];

file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
header('Location:index.php');
