<?php
include 'auth.php';
include 'config.php';
include 'helpers.php';

$file = 'data.json';
if (!file_exists($file)) file_put_contents($file, '[]');
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$activeCount = [];
$totalCount = [];
$totalValueAll = 0.0;
$totalValueActive = 0.0;
$totalValueSold = 0.0;

foreach ($data as $d) {
  $st = norm_status($d['status'] ?? 'aktivni');
  $price = (float)($d['cena'] ?? 0);
  $platformy = ensure_array($d['platformy'] ?? []);

  $totalValueAll += $price;
  if ($st === 'aktivni') $totalValueActive += $price;
  else $totalValueSold += $price;

  foreach ($platformy as $p) {
    $totalCount[$p] = ($totalCount[$p] ?? 0) + 1;
    if ($st === 'aktivni') $activeCount[$p] = ($activeCount[$p] ?? 0) + 1;
  }
}

function limit_class($platform, $activeCount, $LIMITS){
  if (!isset($LIMITS[$platform])) return '';
  $limit = (int)$LIMITS[$platform];
  $c = (int)($activeCount[$platform] ?? 0);
  if ($limit <= 0) return '';
  $ratio = $c / $limit;
  if ($c >= $limit) return 'limit-over';
  if ($ratio >= 0.9) return 'limit-warn';
  return 'limit-ok';
}
?>
<!doctype html>
<html lang="cs">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Inzeráty – Jarda</title>
</head>
<body>
<header class="topbar">
  <div>
    <h1>Evidence inzerátů – Jarda</h1>
    <div class="muted">Tisk má filtry: stav / platformy / s obrázky nebo bez.</div>
  </div>
  <div class="actions">
    <a class="btn" href="import.php">Import CSV</a>
    <a class="btn" href="print.php" target="_blank">Tiskový přehled</a>
  </div>
</header>

<section class="card">
  <h2>Součet hodnoty položek</h2>
  <div class="stats">
    <div class="stat"><div class="stat-k">Celkem</div><div class="stat-v"><?=number_format($totalValueAll, 0, ',', ' ')?> Kč</div></div>
    <div class="stat"><div class="stat-k">Aktivní</div><div class="stat-v"><?=number_format($totalValueActive, 0, ',', ' ')?> Kč</div></div>
    <div class="stat"><div class="stat-k">Prodáno</div><div class="stat-v"><?=number_format($totalValueSold, 0, ',', ' ')?> Kč</div></div>
  </div>
</section>

<section class="card">
  <h2>Přidat inzerát</h2>
  <form method="post" action="save.php" class="grid" enctype="multipart/form-data">
    <div>
      <label>Název</label>
      <input name="nazev" required>
    </div>
    <div>
      <label>Cena (Kč)</label>
      <input name="cena" type="number" step="1" min="0" required>
    </div>
    <div>
      <label>Stav</label>
      <select name="status">
        <option value="aktivni" selected>aktivní</option>
        <option value="prodano">prodáno</option>
      </select>
    </div>
    <div>
      <label>Platformy</label>
      <div class="checks">
        <?php foreach($PLATFORMS as $k=>$v): ?>
          <label class="check"><input type="checkbox" name="platformy[]" value="<?=h($k)?>"> <?=h($v)?></label>
        <?php endforeach; ?>
      </div>
    </div>
    <div class="full">
      <label>Fotky (více souborů)</label>
      <input type="file" name="fotky[]" accept="image/*" multiple>
    </div>
    <div class="full">
      <button class="btn primary">Přidat</button>
      <span class="muted">Prodáno se nepočítá do limitu.</span>
    </div>
  </form>
</section>

<section class="card">
  <h2>Limity platforem</h2>
  <div class="limits">
    <?php foreach ($LIMITS as $k => $l):
      $c = (int)($activeCount[$k] ?? 0);
      $t = (int)($totalCount[$k] ?? 0);
      $cls = limit_class($k, $activeCount, $LIMITS);
    ?>
      <div class="limitbox <?=$cls?>">
        <div class="limit-title"><?=h($PLATFORMS[$k] ?? $k)?></div>
        <div class="limit-main"><b><?=$c?></b> / <?=$l?> <span class="muted">(aktivní)</span></div>
        <div class="muted small">celkem vazeb: <?=$t?></div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<section class="card">
  <h2>Seznam inzerátů</h2>
  <div class="table-wrap">
    <table>
      <thead><tr><th>Galerie</th><th>Název</th><th>Cena</th><th>Platformy</th><th>Stav</th><th>Akce</th></tr></thead>
      <tbody>
      <?php foreach ($data as $i => $d):
        $st = norm_status($d['status'] ?? 'aktivni');
        $stLabel = $st === 'prodano' ? 'prodáno' : 'aktivní';
        $stCls = $st === 'prodano' ? 'status-sold' : 'status-active';
        $platformy = ensure_array($d['platformy'] ?? []);
        $fotky = ensure_array($d['fotky'] ?? []);
      ?>
        <tr>
          <td>
            <?php if (count($fotky) > 0): ?>
              <div class="gallery">
                <?php foreach($fotky as $f): ?>
                  <a class="gitem" href="uploads/<?=h($f)?>" target="_blank"><img class="thumb" src="uploads/<?=h($f)?>" alt=""></a>
                <?php endforeach; ?>
              </div>
            <?php else: ?><span class="muted small">–</span><?php endif; ?>
          </td>
          <td><?=h($d['nazev'] ?? '')?></td>
          <td><?=number_format((float)($d['cena'] ?? 0), 0, ',', ' ')?></td>
          <td><?=h(platforms_to_string($platformy))?></td>
          <td><span class="pill <?=$stCls?>"><?=$stLabel?></span></td>
          <td>
            <a href="edit.php?id=<?=$i?>" class="link">Edit</a>
            <span class="sep">|</span>
            <a href="delete.php?id=<?=$i?>" class="link danger" onclick="return confirm('Opravdu smazat?');">Smazat</a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</section>

<footer class="footer muted small">Ukládáno do <code>data.json</code>, fotky v <code>/uploads</code></footer>
</body>
</html>
