<?php
include 'auth.php';
include 'config.php';
include 'helpers.php';

$file = 'data.json';
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$id = (int)($_GET['id'] ?? -1);
if ($id < 0 || $id >= count($data)) { header('Location:index.php'); exit; }

$d = $data[$id];
$platformy = ensure_array($d['platformy'] ?? []);
$fotky = ensure_array($d['fotky'] ?? []);
$st = norm_status($d['status'] ?? 'aktivni');

function checked($arr,$k){ return in_array($k,$arr,true) ? 'checked' : ''; }
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Editace</title></head><body>
<header class="topbar">
  <div><h1>Editace položky</h1></div>
  <div class="actions"><a class="btn" href="index.php">Zpět</a></div>
</header>

<section class="card">
<form method="post" action="update.php?id=<?=$id?>" class="grid" enctype="multipart/form-data">
  <div>
    <label>Název</label>
    <input name="nazev" value="<?=h($d['nazev'] ?? '')?>" required>
  </div>
  <div>
    <label>Cena (Kč)</label>
    <input name="cena" type="number" step="1" min="0" value="<?=h($d['cena'] ?? '')?>" required>
  </div>
  <div>
    <label>Stav</label>
    <select name="status">
      <option value="aktivni" <?=$st==='aktivni'?'selected':''?>>aktivní</option>
      <option value="prodano" <?=$st==='prodano'?'selected':''?>>prodáno</option>
    </select>
  </div>
  <div>
    <label>Platformy</label>
    <div class="checks">
      <?php foreach($PLATFORMS as $k=>$v): ?>
        <label class="check"><input type="checkbox" name="platformy[]" value="<?=h($k)?>" <?=checked($platformy,$k)?>> <?=h($v)?></label>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="full">
    <label>Aktuální galerie (zaškrtni fotky k odstranění)</label>
    <?php if (count($fotky) > 0): ?>
      <div class="gallery">
        <?php foreach($fotky as $f): ?>
          <label class="gremove">
            <input type="checkbox" name="remove_fotky[]" value="<?=h($f)?>">
            <span><img class="thumb" src="uploads/<?=h($f)?>" alt=""></span>
            <span class="muted small">smazat</span>
          </label>
        <?php endforeach; ?>
      </div>
    <?php else: ?><div class="muted small">Žádné fotky</div><?php endif; ?>
  </div>

  <div class="full">
    <label>Přidat další fotky</label>
    <input type="file" name="fotky[]" accept="image/*" multiple>
  </div>

  <div class="full">
    <button class="btn primary">Uložit změny</button>
  </div>
</form>
</section>
</body></html>
