<?php
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function norm_status($s){
  return ($s==='prodano') ? 'prodano' : 'aktivni';
}

function platforms_to_string($arr){
  if (!is_array($arr)) return '';
  return implode(', ', $arr);
}

function safe_image_ext($name){
  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  return in_array($ext,['jpg','jpeg','png','webp','gif']) ? $ext : '';
}

function ensure_array($x){
  return is_array($x)?$x:[];
}

function upload_many_images($filesKey){
  $saved=[];
  if(!isset($_FILES[$filesKey])) return $saved;
  if(!is_dir('uploads')) mkdir('uploads');
  $f=$_FILES[$filesKey];
  for($i=0;$i<count($f['name']);$i++){
    if($f['error'][$i]!==UPLOAD_ERR_OK) continue;
    $ext=safe_image_ext($f['name'][$i]);
    if(!$ext) continue;
    $name=time().'_'.bin2hex(random_bytes(4)).'.'.$ext;
    move_uploaded_file($f['tmp_name'][$i],'uploads/'.$name);
    $saved[]=$name;
  }
  return $saved;
}
?>