<?php
include 'auth.php';
include 'helpers.php';

$file = 'data.json';
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$id = (int)($_GET['id'] ?? -1);
if ($id < 0 || $id >= count($data)) { header('Location:index.php'); exit; }

$nazev = trim((string)($_POST['nazev'] ?? ''));
$cena = (float)($_POST['cena'] ?? 0);
$platformy = parse_platforms($_POST['platformy_raw'] ?? '');
$status = norm_status($_POST['status'] ?? 'aktivni');

$oldFotky = ensure_array($data[$id]['fotky'] ?? ($data[$id]['foto'] ?? []));

$toRemove = $_POST['remove_fotky'] ?? [];
if (!is_array($toRemove)) $toRemove = [$toRemove];
$toRemoveMap = [];
foreach($toRemove as $r){ $toRemoveMap[(string)$r] = true; }

$newFotky = [];
foreach($oldFotky as $f){
  if (isset($toRemoveMap[$f])) {
    if ($f && file_exists('uploads/' . $f)) @unlink('uploads/' . $f);
  } else {
    $newFotky[] = $f;
  }
}

$added = upload_many_images('fotky');
foreach($added as $f) $newFotky[] = $f;

$data[$id] = [
  'nazev' => $nazev,
  'cena' => $cena,
  'platformy' => $platformy,
  'status' => $status,
  'fotky' => $newFotky
];

file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
header('Location:index.php');
