<?php
include 'auth.php';
include 'helpers.php';

$data = json_decode(file_get_contents('data.json'), true);
if (!is_array($data)) $data = [];
?>
<!doctype html>
<html lang="cs">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Tiskový přehled</title>
<style>
  body{font-family:Arial;margin:20px}
  h1{margin:0 0 10px 0}
  table{width:100%;border-collapse:collapse}
  td,th{border:1px solid #000;padding:6px;font-size:12px}
  .muted{color:#444;font-size:12px;margin-bottom:10px}
  @media print{ button{display:none} }
</style>
</head>
<body>
<button onclick="window.print()">Tisk</button>
<h1>Tiskový přehled inzerátů</h1>
<div class="muted">Vytvořeno: <?=date('Y-m-d H:i')?></div>

<table>
<thead><tr><th>Název</th><th>Cena</th><th>Platformy</th><th>Stav</th></tr></thead>
<tbody>
<?php foreach($data as $d):
  $st = norm_status($d['status'] ?? 'aktivni');
  $stLabel = $st === 'prodano' ? 'prodáno' : 'aktivní';
  $platforms = $d['platformy'] ?? ($d['platforma'] ?? []);
  if (!is_array($platforms)) $platforms = parse_platforms($platforms);
?>
<tr>
  <td><?=h($d['nazev'] ?? '')?></td>
  <td><?=number_format((float)($d['cena'] ?? 0), 0, ',', ' ')?></td>
  <td><?=h(platforms_to_string($platforms))?></td>
  <td><?=$stLabel?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<script>window.print();</script>
</body></html>
