<?php
include 'auth.php';
include 'helpers.php';

$file = 'data.json';
if (!file_exists($file)) file_put_contents($file, '[]');

$err = '';
if ($_FILES) {
  if (!isset($_FILES['f']) || $_FILES['f']['error'] !== UPLOAD_ERR_OK) {
    $err = 'Soubor se nepodařilo nahrát.';
  } else {
    $rows = array_map('str_getcsv', file($_FILES['f']['tmp_name']));
    if (count($rows) > 0 && isset($rows[0][0]) && strtolower(trim($rows[0][0])) === 'nazev') {
      array_shift($rows);
    }
    $data = json_decode(file_get_contents($file), true);
    if (!is_array($data)) $data = [];

    foreach ($rows as $r) {
      if (count($r) < 3) continue;
      $nazev = trim((string)$r[0]);
      $cena = (float)str_replace([' ', 'Kč', 'kc', 'KC'], '', (string)$r[1]);
      $platformy = parse_platforms($r[2]);
      $status = isset($r[3]) ? norm_status($r[3]) : 'aktivni';
      if ($nazev === '') continue;
      $data[] = ['nazev'=>$nazev,'cena'=>$cena,'platformy'=>$platformy,'status'=>$status,'fotky'=>[]];
    }
    file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    header('Location:index.php'); exit;
  }
}
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Import</title></head><body>
<header class="topbar">
  <div>
    <h1>Import CSV</h1>
    <div class="muted small">Sloupce: Nazev, Cena, Platformy (např. "sbazar, bazos"), (volitelně) Status</div>
  </div>
  <div class="actions"><a class="btn" href="index.php">Zpět</a></div>
</header>
<section class="card">
  <?php if ($err): ?><div class="alert"><?=$err?></div><?php endif; ?>
  <form method="post" enctype="multipart/form-data" class="grid">
    <div class="full">
      <label>CSV soubor</label>
      <input type="file" name="f" accept=".csv,text/csv" required>
    </div>
    <div class="full">
      <button class="btn primary">Importovat</button>
    </div>
  </form>
</section>
</body></html>
