<?php
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function norm_platform($p){
  $p = trim(strtolower((string)$p));
  $map = [
    'sbazar' => 'sbazar',
    'bazos'  => 'bazos',
    'bazoš'  => 'bazos',
    'aukro'  => 'aukro',
    'vinted' => 'vinted',
  ];
  return $map[$p] ?? $p;
}

function parse_platforms($raw){
  $raw = (string)$raw;
  $parts = preg_split('/[,;\n\r\t ]+/', trim($raw));
  $out = [];
  foreach($parts as $p){
    if($p==='') continue;
    $p2 = norm_platform($p);
    $out[$p2] = true;
  }
  return array_values(array_keys($out));
}

function platforms_to_string($arr){
  if (!is_array($arr)) return (string)$arr;
  return implode(', ', $arr);
}

function norm_status($s){
  $s = trim(strtolower((string)$s));
  if ($s === 'prodano' || $s === 'prodané' || $s === 'prodáno') return 'prodano';
  return 'aktivni';
}

function safe_image_ext($name){
  $name = strtolower((string)$name);
  $ext = pathinfo($name, PATHINFO_EXTENSION);
  $allowed = ['jpg','jpeg','png','webp','gif'];
  if (in_array($ext, $allowed, true)) return $ext;
  return '';
}

function ensure_array($x){
  if (is_array($x)) return $x;
  if ($x === null || $x === '') return [];
  return [$x];
}

function upload_many_images($filesKey){
  $saved = [];
  if (!isset($_FILES[$filesKey])) return $saved;
  if (!is_dir('uploads')) mkdir('uploads');

  $f = $_FILES[$filesKey];
  $names = $f['name'] ?? [];
  if (!is_array($names)) return $saved;

  for ($i=0; $i<count($names); $i++){
    if (($f['error'][$i] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) continue;
    if (($f['size'][$i] ?? 0) <= 0) continue;
    $ext = safe_image_ext($names[$i]);
    if ($ext === '') continue;

    $fname = time() . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
    if (move_uploaded_file($f['tmp_name'][$i], 'uploads/' . $fname)) {
      $saved[] = $fname;
    }
  }
  return $saved;
}
?>