<?php
include 'auth.php';
include 'helpers.php';

$file = 'data.json';
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$id = (int)($_GET['id'] ?? -1);
if ($id < 0 || $id >= count($data)) { header('Location:index.php'); exit; }

$oldFoto = $data[$id]['foto'] ?? '';

$nazev = trim((string)($_POST['nazev'] ?? ''));
$cena = (float)($_POST['cena'] ?? 0);
$platformy = parse_platforms($_POST['platformy_raw'] ?? '');
$status = norm_status($_POST['status'] ?? 'aktivni');

$foto = $oldFoto;

// odstranění fotky
if (isset($_POST['remove_foto']) && $_POST['remove_foto'] == '1') {
  if ($foto && file_exists('uploads/' . $foto)) @unlink('uploads/' . $foto);
  $foto = '';
}

// nová fotka přepíše starou
if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK && $_FILES['foto']['size'] > 0) {
  if ($foto && file_exists('uploads/' . $foto)) @unlink('uploads/' . $foto);
  $ext = safe_image_ext($_FILES['foto']['name']);
  if ($ext !== '') {
    $foto = time() . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
    move_uploaded_file($_FILES['foto']['tmp_name'], 'uploads/' . $foto);
  } else {
    $foto = '';
  }
}

$data[$id] = [
  'nazev' => $nazev,
  'cena' => $cena,
  'platformy' => $platformy,
  'status' => $status,
  'foto' => $foto
];

file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
header('Location:index.php');
