<?php
include 'auth.php';
include 'helpers.php';

$file = 'data.json';
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$nazev = trim((string)($_POST['nazev'] ?? ''));
$cena = (float)($_POST['cena'] ?? 0);
$status = norm_status($_POST['status'] ?? 'aktivni');
$platformy = parse_platforms($_POST['platformy_raw'] ?? '');

// fotka
$foto = '';
if (!is_dir('uploads')) mkdir('uploads');
if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK && $_FILES['foto']['size'] > 0) {
  $ext = safe_image_ext($_FILES['foto']['name']);
  if ($ext !== '') {
    $foto = time() . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
    move_uploaded_file($_FILES['foto']['tmp_name'], 'uploads/' . $foto);
  }
}

$data[] = [
  'nazev' => $nazev,
  'cena' => $cena,
  'platformy' => $platformy,
  'status' => $status,
  'foto' => $foto
];

file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
header('Location: index.php');
