<?php
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function norm_platform($p){
  $p = trim(strtolower((string)$p));
  $map = [
    'sbazar' => 'sbazar',
    'bazos'  => 'bazos',
    'bazoš'  => 'bazos',
    'aukro'  => 'aukro',
    'vinted' => 'vinted',
  ];
  return $map[$p] ?? $p;
}

function parse_platforms($raw){
  // dovolíme zadat více platforem: "sbazar, bazos" nebo "sbazar;aukro"
  $raw = (string)$raw;
  $parts = preg_split('/[,;\n\r\t ]+/', trim($raw));
  $out = [];
  foreach($parts as $p){
    if($p==='') continue;
    $p2 = norm_platform($p);
    $out[$p2] = true;
  }
  return array_values(array_keys($out));
}

function platforms_to_string($arr){
  if (!is_array($arr)) return (string)$arr;
  return implode(', ', $arr);
}

function norm_status($s){
  $s = trim(strtolower((string)$s));
  if ($s === 'prodano' || $s === 'prodané' || $s === 'prodáno') return 'prodano';
  return 'aktivni';
}

function safe_image_ext($name){
  $name = strtolower((string)$name);
  $ext = pathinfo($name, PATHINFO_EXTENSION);
  $allowed = ['jpg','jpeg','png','webp','gif'];
  if (in_array($ext, $allowed, true)) return $ext;
  return '';
}
?>