<?php
include 'auth.php';
include 'helpers.php';

$data = json_decode(file_get_contents('data.json'), true);
if (!is_array($data)) $data = [];

$id = (int)($_GET['id'] ?? -1);
if ($id < 0 || $id >= count($data)) { header('Location:index.php'); exit; }

$d = $data[$id];
$platforms = $d['platformy'] ?? ($d['platforma'] ?? []);
if (!is_array($platforms)) $platforms = parse_platforms($platforms);
$platformStr = platforms_to_string($platforms);
$st = norm_status($d['status'] ?? 'aktivni');
$foto = $d['foto'] ?? '';
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Editace</title></head><body>
<header class="topbar">
  <div><h1>Editace položky</h1></div>
  <div class="actions"><a class="btn" href="index.php">Zpět</a></div>
</header>

<section class="card">
<form method="post" action="update.php?id=<?=$id?>" class="grid" enctype="multipart/form-data">
  <div>
    <label>Název</label>
    <input name="nazev" value="<?=h($d['nazev'] ?? '')?>" required>
  </div>
  <div>
    <label>Cena (Kč)</label>
    <input name="cena" type="number" step="1" min="0" value="<?=h($d['cena'] ?? '')?>" required>
  </div>
  <div>
    <label>Platformy (více odděl čárkou)</label>
    <input name="platformy_raw" value="<?=h($platformStr)?>">
  </div>
  <div>
    <label>Stav</label>
    <select name="status">
      <option value="aktivni" <?=$st==='aktivni'?'selected':''?>>aktivní</option>
      <option value="prodano" <?=$st==='prodano'?'selected':''?>>prodáno</option>
    </select>
  </div>

  <div class="full">
    <label>Aktuální fotka</label>
    <?php if ($foto): ?>
      <div class="row">
        <a href="uploads/<?=h($foto)?>" target="_blank"><img class="thumb" src="uploads/<?=h($foto)?>" alt=""></a>
        <label class="inline"><input type="checkbox" name="remove_foto" value="1"> odstranit fotku</label>
      </div>
    <?php else: ?>
      <div class="muted small">Žádná fotka</div>
    <?php endif; ?>
  </div>

  <div class="full">
    <label>Nahrát novou fotku (volitelné)</label>
    <input type="file" name="foto" accept="image/*">
  </div>

  <div class="full">
    <button class="btn primary">Uložit změny</button>
  </div>
</form>
</section>
</body></html>
