<?php
include 'auth.php';
include 'config.php';
include 'helpers.php';

$file = 'data.json';
if (!file_exists($file)) file_put_contents($file, '[]');
$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

$activeCount = [];
$totalCount = [];
foreach ($data as $d) {
  $p = norm_platform($d['platforma'] ?? '');
  $st = norm_status($d['status'] ?? 'aktivni');

  $totalCount[$p] = ($totalCount[$p] ?? 0) + 1;
  if ($st === 'aktivni') $activeCount[$p] = ($activeCount[$p] ?? 0) + 1;
}

function limit_class($platform, $activeCount, $LIMITS){
  if (!isset($LIMITS[$platform])) return '';
  $limit = (int)$LIMITS[$platform];
  $c = (int)($activeCount[$platform] ?? 0);
  if ($limit <= 0) return '';
  $ratio = $c / $limit;
  if ($c >= $limit) return 'limit-over';
  if ($ratio >= 0.9) return 'limit-warn';
  return 'limit-ok';
}
?>
<!doctype html>
<html lang="cs">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Inzeráty – Jarda</title>
</head>
<body>
<header class="topbar">
  <div>
    <h1>Evidence inzerátů – Jarda</h1>
    <div class="muted">Limity se počítají pouze z <b>aktivních</b> inzerátů.</div>
  </div>
  <div class="actions">
    <a class="btn" href="import.php">Import CSV</a>
    <a class="btn" href="print.php" target="_blank">Tiskový přehled</a>
  </div>
</header>

<section class="card">
  <h2>Přidat inzerát</h2>
  <form method="post" action="save.php" class="grid">
    <div>
      <label>Název</label>
      <input name="nazev" required>
    </div>
    <div>
      <label>Cena (Kč)</label>
      <input name="cena" type="number" step="1" min="0" required>
    </div>
    <div>
      <label>Platforma</label>
      <input name="platforma" placeholder="sbazar / bazos / aukro / vinted" required>
    </div>
    <div>
      <label>Stav</label>
      <select name="status">
        <option value="aktivni" selected>aktivní</option>
        <option value="prodano">prodáno</option>
      </select>
    </div>
    <div class="full">
      <button class="btn primary">Přidat</button>
      <span class="muted">Prodáno se nepočítá do limitu.</span>
    </div>
  </form>
</section>

<section class="card">
  <h2>Limity platforem</h2>
  <div class="limits">
    <?php foreach ($LIMITS as $k => $l):
      $k2 = norm_platform($k);
      $c = (int)($activeCount[$k2] ?? 0);
      $t = (int)($totalCount[$k2] ?? 0);
      $cls = limit_class($k2, $activeCount, $LIMITS);
    ?>
      <div class="limitbox <?=$cls?>">
        <div class="limit-title"><?=h($k2)?></div>
        <div class="limit-main"><b><?=$c?></b> / <?=$l?> <span class="muted">(aktivní)</span></div>
        <div class="muted small">celkem položek: <?=$t?></div>
        <?php if ($c >= $l): ?>
          <div class="limit-msg">⚠️ Limit dosažen / překročen</div>
        <?php elseif ($l>0 && $c/$l >= 0.9): ?>
          <div class="limit-msg">⚠️ Blížíš se k limitu</div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<section class="card">
  <h2>Seznam inzerátů</h2>
  <div class="table-wrap">
    <table>
      <thead>
        <tr><th>Název</th><th>Cena</th><th>Platforma</th><th>Stav</th><th>Akce</th></tr>
      </thead>
      <tbody>
      <?php foreach ($data as $i => $d):
        $p = norm_platform($d['platforma'] ?? '');
        $st = norm_status($d['status'] ?? 'aktivni');
        $stLabel = $st === 'prodano' ? 'prodáno' : 'aktivní';
        $stCls = $st === 'prodano' ? 'status-sold' : 'status-active';
      ?>
        <tr>
          <td><?=h($d['nazev'] ?? '')?></td>
          <td><?=h($d['cena'] ?? '')?></td>
          <td><?=h($p)?></td>
          <td><span class="pill <?=$stCls?>"><?=$stLabel?></span></td>
          <td>
            <a href="edit.php?id=<?=$i?>" class="link">Edit</a>
            <span class="sep">|</span>
            <a href="delete.php?id=<?=$i?>" class="link danger" onclick="return confirm('Opravdu smazat?');">Smazat</a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</section>

<footer class="footer muted small">Ukládáno do <code>data.json</code></footer>
</body>
</html>
