<?php
include 'auth.php';
include 'helpers.php';

$data = json_decode(file_get_contents('data.json'), true);
if (!is_array($data)) $data = [];

$id = (int)($_GET['id'] ?? -1);
if ($id < 0 || $id >= count($data)) { header('Location:index.php'); exit; }

$d = $data[$id];
$p = norm_platform($d['platforma'] ?? '');
$st = norm_status($d['status'] ?? 'aktivni');
?>
<!doctype html><html lang="cs"><head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="style.css">
<title>Editace</title></head><body>
<header class="topbar">
  <div><h1>Editace položky</h1></div>
  <div class="actions"><a class="btn" href="index.php">Zpět</a></div>
</header>

<section class="card">
<form method="post" action="update.php?id=<?=$id?>" class="grid">
  <div>
    <label>Název</label>
    <input name="nazev" value="<?=h($d['nazev'] ?? '')?>" required>
  </div>
  <div>
    <label>Cena (Kč)</label>
    <input name="cena" type="number" step="1" min="0" value="<?=h($d['cena'] ?? '')?>" required>
  </div>
  <div>
    <label>Platforma</label>
    <input name="platforma" value="<?=h($p)?>" required>
  </div>
  <div>
    <label>Stav</label>
    <select name="status">
      <option value="aktivni" <?=$st==='aktivni'?'selected':''?>>aktivní</option>
      <option value="prodano" <?=$st==='prodano'?'selected':''?>>prodáno</option>
    </select>
  </div>
  <div class="full">
    <button class="btn primary">Uložit změny</button>
  </div>
</form>
</section>
</body></html>
