# Horliko podlahářství – web (HTML/CSS/JS)

## Spuštění
1. Rozbalte ZIP
2. Otevřete `index.html` v prohlížeči

## Co je nového (v2)
- Přidané logo: `assets/logo.png`
- Barvy upravené dle loga (zlatá / béžová / olivová)
- Přidané ilustrační obrázky v galerii a v hero kartě (SVG v `assets/`)

## Kontakt/Formulář
Formulář je čistě klientský (bez backendu):
- po odeslání uloží data do `localStorage` (demo)
- zároveň otevře e-mail klienta přes `mailto:` s předvyplněným textem

Pro ostré odesílání můžete formulář napojit např. na:
- Formspree
- Netlify Forms
- vlastní API endpoint

## Výměna obrázků za vlastní fotky
Nahrajte vlastní fotky do `assets/` a v `index.html` v sekci „Realizace“ změňte `src="assets/..."`.



## Odesílání formuláře bez vlastního serveru (funguje na běžném webhostingu)
Formulář je nastaven tak, aby fungoval na jakémkoli statickém hostingu bez backendu přes službu FormSubmit.co.

- data se odešlou klasicky přes `<form action="...">`
- po odeslání se uživateli zobrazí potvrzení

Poznámka: FormSubmit může při prvním použití vyžadovat potvrzení cílového e-mailu (anti-spam).
Cílový e-mail je aktuálně nastaven na `hornik34@seznam.cz` v `index.html`.


## Admin verze – přepínání dostupnosti
V balíčku je přidaná stránka `admin/admin.html`, kde přepnete:
- stav: available / limited / unavailable
- text dostupnosti

Ukládá se to do `localStorage`, takže změna je vidět pouze v tom prohlížeči/zařízení, kde ji nastavíte.
Pro globální změny pro všechny návštěvníky je potřeba backend (API/CMS).


## Namecheap (cPanel) – globální admin přepínání dostupnosti
Na Namecheap hostingu běží PHP, takže admin přepínání funguje globálně pro všechny návštěvníky.

### Soubory
- `api/status.json` – uložený stav (zapisuje se)
- `api/get.php` – vrací JSON pro web
- `api/set.php` – uloží JSON (používá token z `api/config.php`)
- `admin/admin.html` + `admin/admin.js` – jednoduchý admin panel

### Zabezpečení adminu (doporučeno)
Doporučuji zaheslovat `admin/admin.html` (nebo celou složku) přes cPanel „Directory Privacy“ na Namecheap. 
Token je aktuálně vygenerovaný a uložený v `api/config.php` (ADMIN_TOKEN).

### Tipy
- Pokud by ukládání nefungovalo, nastavte práva pro `api/status.json` tak, aby do něj PHP mohlo zapisovat.


### Admin ve složce /admin
Admin panel je nyní ve složce `admin/`:
- otevřete `https://vasedomena.cz/admin/admin.html`

Tuto složku můžete jednoduše zaheslovat v cPanelu přes „Directory Privacy“.


## Admin – přidávání fotek do galerie (Namecheap / PHP)
V adminu (`/admin/admin.html`) je nově možnost nahrát fotky do galerie.
- API endpoint: `api/upload.php` (chráněné tokenem)
- Fotky se ukládají do `assets/uploads/`
- Seznam se ukládá do `api/gallery.json` a web ho načítá z `api/gallery.php`

Poznámky:
- Na hostingu musí být povolené PHP a upload souborů.
- Pokud upload nefunguje, nastavte práva zápisu pro `assets/uploads/` a `api/gallery.json`.


## Admin – mazání fotek a přeskládání pořadí
V adminu (`/admin/admin.html`) je nově seznam fotek:
- **Přeskládání pořadí**: přetáhni fotku (drag & drop) a klikni „Uložit pořadí“
- **Mazání**: tlačítko „Smazat“ odstraní položku z `api/gallery.json` a pokud je soubor v `assets/uploads/`, smaže i samotný soubor

API:
- `api/gallery_set.php` (uložení pořadí / celého seznamu)
- `api/gallery_delete.php` (smazání položky + souboru z uploads)


## Admin – editace popisku a kategorie
V seznamu fotek v adminu můžete přímo upravovat:
- **Popisek** (textové pole)
- **Kategorie** (select)

Po úpravách klikněte **„Uložit pořadí“** (tím se uloží i změny popisků/kategorií do `api/gallery.json`).
