// Admin (Namecheap shared hosting): saves availability to server via PHP (api/set.php)
(function(){
  const API_SET = "../api/set.php";
  const API_GET = "../api/get.php";
  const TOKEN = "BMXpCxm5N9viSEuJRcrkSLDVzr4GFQIG"; // token je i v api/config.php

  const $ = (s) => document.querySelector(s);
  const $$ = (s) => Array.from(document.querySelectorAll(s));

  const statusEl = $("#status");
  const setStatus = (t) => { if (statusEl) statusEl.textContent = t || ""; };

  const msg = $("#msg");
  const currentTag = $("#currentTag");
  const currentLabel = $("#currentLabel");

  let selected = "available";

  const palette = {
    available: { dot: "#2ecc71", label: "Přijímáme zakázky" },
    limited: { dot: "#f1c40f", label: "Omezená kapacita" },
    unavailable: { dot: "#e74c3c", label: "Nepřijímáme" },
  };

  function paintTag(st){
    if (!currentTag) return;
    const dot = currentTag.querySelector(".dot");
    if (dot) dot.style.background = palette[st].dot;
    if (currentLabel) currentLabel.textContent = palette[st].label;
  }

  function highlight(st){
    $$(".seg button").forEach(b => {
      const is = b.dataset.status === st;
      b.classList.toggle("btn--ghost", !is);
    });
  }

  async function load(){
    try {
      const res = await fetch(API_GET, { cache: "no-store" });
      if (res.ok) {
        const data = await res.json();
        if (data?.status) selected = data.status;
        if (msg) msg.value = data?.text || "Aktuálně přijímáme nové zakázky";
      }
    } catch(_){
      if (msg) msg.value = "Aktuálně přijímáme nové zakázky";
    }
    paintTag(selected);
    highlight(selected);
  }

  $$(".seg button").forEach(b => {
    b.addEventListener("click", () => {
      selected = b.dataset.status;
      paintTag(selected);
      highlight(selected);
      setStatus("");
    });
  });

  $("#save")?.addEventListener("click", async () => {
    const text = (msg?.value || "").trim() || "Aktuálně přijímáme nové zakázky";
    const body = new URLSearchParams();
    body.set("token", TOKEN);
    body.set("status", selected);
    body.set("text", text);

    setStatus("Ukládám…");

    try {
      const res = await fetch(API_SET, {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body
      });
      const data = await res.json().catch(() => null);
      if (!res.ok) {
        throw new Error(data?.error || `Chyba (HTTP ${res.status})`);
      }
      setStatus("Uloženo. Změna je viditelná pro všechny návštěvníky.");
    } catch (e) {
      console.error(e);
      setStatus("Nepodařilo se uložit. Zkontrolujte, že server podporuje PHP a že je možné zapisovat do api/status.json.");
    }
  });

  $("#reset")?.addEventListener("click", async () => {
    selected = "available";
    if (msg) msg.value = "Aktuálně přijímáme nové zakázky";
    paintTag(selected);
    highlight(selected);

    const body = new URLSearchParams();
    body.set("token", TOKEN);
    body.set("status", selected);
    body.set("text", msg.value);

    setStatus("Obnovuji…");
    try {
      const res = await fetch(API_SET, {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body
      });
      const data = await res.json().catch(() => null);
      if (!res.ok) throw new Error(data?.error || `Chyba (HTTP ${res.status})`);
      setStatus("Výchozí stav uložen.");
    } catch (e) {
      console.error(e);
      setStatus("Nepodařilo se uložit výchozí stav.");
    }
  });

  load();
})();
