// Simple admin toggle (no backend) – stores availability in localStorage
(function(){
  const key = "horliko_availability";

  const $ = (s) => document.querySelector(s);
  const $$ = (s) => Array.from(document.querySelectorAll(s));

  const statusEl = $("#status");
  const setStatus = (t) => { if (statusEl) statusEl.textContent = t || ""; };

  const msg = $("#msg");
  const currentTag = $("#currentTag");
  const currentLabel = $("#currentLabel");

  let selected = "available";

  const palette = {
    available: { dot: "#2ecc71", label: "Přijímáme zakázky" },
    limited: { dot: "#f1c40f", label: "Omezená kapacita" },
    unavailable: { dot: "#e74c3c", label: "Nepřijímáme" },
  };

  function paintTag(st){
    if (!currentTag) return;
    const dot = currentTag.querySelector(".dot");
    if (dot) dot.style.background = palette[st].dot;
    if (currentLabel) currentLabel.textContent = palette[st].label;
  }

  function load(){
    let stored = null;
    try { stored = JSON.parse(localStorage.getItem(key) || "null"); } catch(_) {}
    if (stored && stored.status){
      selected = stored.status;
      if (msg && stored.text) msg.value = stored.text;
    } else {
      if (msg) msg.value = "Aktuálně přijímáme nové zakázky";
    }
    paintTag(selected);
    highlight(selected);
  }

  function highlight(st){
    $$(".seg button").forEach(b => {
      const is = b.dataset.status === st;
      b.classList.toggle("btn--ghost", !is);
    });
  }

  $$(".seg button").forEach(b => {
    b.addEventListener("click", () => {
      selected = b.dataset.status;
      paintTag(selected);
      highlight(selected);
      setStatus("");
    });
  });

  $("#save")?.addEventListener("click", () => {
    const payload = { status: selected, text: (msg?.value || "").trim() || "Aktuálně přijímáme nové zakázky" };
    localStorage.setItem(key, JSON.stringify(payload));
    setStatus("Uloženo. Otevřete web a uvidíte změnu.");
  });

  $("#reset")?.addEventListener("click", () => {
    localStorage.removeItem(key);
    selected = "available";
    if (msg) msg.value = "Aktuálně přijímáme nové zakázky";
    paintTag(selected);
    highlight(selected);
    setStatus("Výchozí stav obnoven.");
  });

  load();
})();
