// Horliko podlahářství - interactivity (menu, reveal, form validation)

const $ = (sel, root = document) => root.querySelector(sel);
const $$ = (sel, root = document) => Array.from(root.querySelectorAll(sel));

function initYear() {
  const y = new Date().getFullYear();
  const el = $("#year");
  if (el) el.textContent = y;
}

function initNav() {
  const toggle = $("#navToggle");
  const nav = $("#siteNav");
  if (!toggle || !nav) return;

  const setOpen = (open) => {
    nav.classList.toggle("is-open", open);
    toggle.setAttribute("aria-expanded", String(open));
    document.body.classList.toggle("nav-open", open);
  };

  toggle.addEventListener("click", () => {
    const isOpen = nav.classList.contains("is-open");
    setOpen(!isOpen);
  });

  nav.addEventListener("click", (e) => {
    const a = e.target.closest("a");
    if (!a) return;
    setOpen(false);
  });

  document.addEventListener("keydown", (e) => {
    if (e.key === "Escape") setOpen(false);
  });
}

function initReveal() {
  const els = $$(".reveal");
  if (!("IntersectionObserver" in window)) {
    els.forEach(el => el.classList.add("is-visible"));
    return;
  }
  const io = new IntersectionObserver((entries) => {
    for (const entry of entries) {
      if (entry.isIntersecting) {
        entry.target.classList.add("is-visible");
        io.unobserve(entry.target);
      }
    }
  }, { threshold: 0.12 });
  els.forEach(el => io.observe(el));
}

function validateEmail(email) {
  return /^[^\s@]+@[^\s@]+\.[^\s@]{2,}$/.test(String(email).trim());
}

function setFieldError(name, msg) {
  const el = document.querySelector(`.error[data-for="${name}"]`);
  if (el) el.textContent = msg || "";
}

function initForm() {
  const form = $("#contactForm");
  if (!form) return;

  const status = $("#formStatus");
  const setStatus = (msg) => { if (status) status.textContent = msg || ""; };

  const getValue = (id) => (document.getElementById(id)?.value ?? "").trim();

  const validate = () => {
    let ok = true;
    ["name", "email", "service", "message", "gdpr"].forEach(k => setFieldError(k, ""));

    const name = getValue("name");
    const email = getValue("email");
    const service = getValue("service");
    const message = getValue("message");
    const gdpr = document.getElementById("gdpr")?.checked;

    if (name.length < 2) { setFieldError("name", "Zadejte prosím jméno."); ok = false; }
    if (!validateEmail(email)) { setFieldError("email", "Zadejte prosím platný e-mail."); ok = false; }
    if (!service) { setFieldError("service", "Vyberte prosím službu."); ok = false; }
    if (message.length < 10) { setFieldError("message", "Popište prosím zakázku (alespoň 10 znaků)."); ok = false; }
    if (!gdpr) { setFieldError("gdpr", "Souhlas je povinný."); ok = false; }

    return ok;
  };

  // Po návratu z odeslání zobraz potvrzení
  const params = new URLSearchParams(window.location.search);
  if (params.get("sent") === "1") {
    setStatus(""); openSuccessModal();
    params.delete("sent");
    const clean = window.location.pathname + (params.toString() ? "?" + params.toString() : "") + "#kontakt";
    window.history.replaceState({}, "", clean);
  }

  form.addEventListener("submit", (e) => {
    if (!validate()) {
      e.preventDefault();
      setStatus("Zkontrolujte prosím vyplnění polí.");
      return;
    }

    // Nastav _next na aktuální stránku + ?sent=1#kontakt
    const next = form.querySelector('input[name="_next"]');
    if (next) {
      const url = new URL(window.location.href);
      url.searchParams.set("sent", "1");
      url.hash = "kontakt";
      next.value = url.toString();
    }

    setStatus("Odesílám…");
  });
}

initYear();

initNav();
initNav();
initReveal();
initForm();
