document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("contactForm");
  const modal = document.getElementById("successModal");
  const closeBtn = document.getElementById("closeModal");

  form.addEventListener("submit", async e => {
    e.preventDefault();
    try {
      const res = await fetch(form.action, {
        method: "POST",
        body: new FormData(form),
        headers: { "Accept": "application/json" }
      });
      if (!res.ok) throw new Error();
      form.reset();
      modal.style.display = "flex";
    } catch {
      alert("Nepodařilo se odeslat.");
    }
  });

  closeBtn.onclick = () => modal.style.display = "none";
});
