<?php
require_once __DIR__ . '/functions.php';

$url = trim($_POST['url'] ?? '');
$shop = trim($_POST['shop'] ?? '');
$watch_enabled = (int)($_POST['watch_enabled'] ?? 1);

if (!$url) {
    header('Location: /index.php?err=1#admin');
    exit;
}

$shop = $shop ?: detect_shop($url);

try {
    $data = scrape_product($url);
} catch (Throwable $e) {
    log_refresh('ADD FAILED ' . $url . ' | ' . $e->getMessage());
    header('Location: /index.php?err=1#admin');
    exit;
}

$db = db();

$st = $db->prepare("SELECT * FROM products WHERE url = ?");
$st->execute([$url]);
$existing = $st->fetch(PDO::FETCH_ASSOC);

if ($existing) {
    $id = (int)$existing['id'];

    $name = $data['name'] ?: $existing['name'];
    $image_url = $data['image_url'] ?: $existing['image_url'];

    $price = $existing['price'];
    if ($data['price'] !== null) $price = (float)$data['price'];

    $currency = $data['currency'] ?: ($existing['currency'] ?: 'CZK');

    $image_path = $existing['image_path'];
    if (!$image_path && $image_url) {
        $image_path = download_image($image_url, $id . '_' . $shop);
    }

    $up = $db->prepare("UPDATE products SET shop=?, name=?, price=?, currency=?, image_url=?, image_path=?, watch_enabled=?, updated_at=? WHERE id=?");
    $up->execute([$shop, $name, $price, $currency, $image_url, $image_path, $watch_enabled, now_iso(), $id]);

    if ($data['price'] !== null) {
        add_price_history($db, $id, (float)$data['price'], $currency);
    }
} else {
    $ins = $db->prepare("INSERT INTO products(url, shop, name, price, currency, image_url, image_path, watch_enabled, created_at, updated_at)
                         VALUES(?,?,?,?,?,?,?,?,?,?)");
    $now = now_iso();
    $ins->execute([
        $url,
        $shop,
        $data['name'],
        $data['price'],
        $data['currency'] ?: 'CZK',
        $data['image_url'],
        null,
        $watch_enabled,
        $now,
        $now
    ]);

    $id = (int)$db->lastInsertId();

    if ($data['image_url']) {
        $image_path = download_image($data['image_url'], $id . '_' . $shop);
        if ($image_path) {
            $up = $db->prepare("UPDATE products SET image_path=? WHERE id=?");
            $up->execute([$image_path, $id]);
        }
    }

    if ($data['price'] !== null) {
        add_price_history($db, $id, (float)$data['price'], $data['currency'] ?: 'CZK');
    }
}

header('Location: /index.php?ok=1#admin');
exit;
