<?php
require_once __DIR__ . '/functions.php';
session_start();

define('ADMIN_PIN', '9725');

$flash = '';
if (isset($_GET['ok'])) $flash = 'Produkt přidán / aktualizován.';
if (isset($_GET['err'])) $flash = 'Nepodařilo se stáhnout data. Zkontroluj URL nebo log.';
if (isset($_GET['badpin'])) $flash = 'Špatný PIN.';

if (($_POST['action'] ?? '') === 'login') {
    $pin = trim((string)($_POST['pin'] ?? ''));
    if (hash_equals(ADMIN_PIN, $pin)) {
        $_SESSION['is_admin'] = 1;
        header('Location: index.php#admin');
        exit;
    } else {
        header('Location: index.php?badpin=1#admin');
        exit;
    }
}

if (($_POST['action'] ?? '') === 'logout') {
    unset($_SESSION['is_admin']);
    header('Location: index.php');
    exit;
}

$is_admin = !empty($_SESSION['is_admin']);

$db = db();
$selected_shop = trim($_GET['shop'] ?? '');

if ($selected_shop) {
    $st = $db->prepare("SELECT * FROM products WHERE shop = ? ORDER BY updated_at DESC");
    $st->execute([$selected_shop]);
} else {
    $st = $db->query("SELECT * FROM products ORDER BY updated_at DESC");
}
$products = $st->fetchAll(PDO::FETCH_ASSOC);

$shops = $db->query("SELECT DISTINCT shop FROM products ORDER BY shop")->fetchAll(PDO::FETCH_COLUMN);

$history = [];
if ($products) {
    $ids = array_map(fn($p) => (int)$p['id'], $products);
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $hst = $db->prepare("SELECT * FROM price_history WHERE product_id IN ($placeholders) ORDER BY checked_at DESC");
    $hst->execute($ids);
    while ($row = $hst->fetch(PDO::FETCH_ASSOC)) {
        $pid = (int)$row['product_id'];
        if (!isset($history[$pid])) $history[$pid] = [];
        if (count($history[$pid]) < 10) $history[$pid][] = $row;
    }
}

$title = APP_TITLE;
include __DIR__ . '/partials/header.php';
?>

<?php if ($flash): ?>
  <div class="mb-4 rounded-xl border bg-amber-50 px-4 py-3 text-amber-900"><?= h($flash) ?></div>
<?php endif; ?>

<div class="flex flex-col gap-4 md:flex-row md:items-end md:justify-between">
  <div>
    <h1 class="text-xl font-semibold">Přehled produktů</h1>
    <p class="mt-1 text-sm text-slate-600">Filtrovat podle obchodu a kliknout rovnou na produkt.</p>
  </div>

  <div class="flex gap-2 items-center">
    <select id="shopFilter" class="rounded-xl border bg-white px-3 py-2 text-sm">
      <option value="">Všechny obchody</option>
      <?php foreach ($shops as $s): ?>
        <option value="<?= h($s) ?>" <?= $selected_shop === $s ? 'selected' : '' ?>><?= h($s) ?></option>
      <?php endforeach; ?>
    </select>
    <a href="#admin" class="rounded-xl bg-slate-900 px-3 py-2 text-sm text-white hover:bg-slate-800">Admin</a>
  </div>
</div>

<?php if (!$products): ?>
  <div class="mt-6 rounded-2xl border bg-white p-6 text-sm text-slate-600">
    Zatím tu nic není. Přidej první produkt v <a class="underline" href="#admin">adminu</a>.
  </div>
<?php else: ?>
  <div class="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
    <?php foreach ($products as $p): ?>
      <article class="rounded-2xl border bg-white p-4 shadow-sm hover:shadow transition">
        <div class="aspect-[4/3] overflow-hidden rounded-xl bg-slate-100 flex items-center justify-center">
          <?php if (!empty($p['image_path']) && file_exists(__DIR__ . '/static/' . $p['image_path'])): ?>
            <img src="static/<?= h($p['image_path']) ?>" alt="<?= h($p['name'] ?: 'produkt') ?>" class="h-full w-full object-cover">
          <?php elseif (!empty($p['image_url'])): ?>
            <img src="<?= h($p['image_url']) ?>" alt="<?= h($p['name'] ?: 'produkt') ?>" class="h-full w-full object-cover">
          <?php else: ?>
            <div class="text-xs text-slate-500">Bez obrázku</div>
          <?php endif; ?>
        </div>

        <div class="mt-3">
          <div class="flex items-start justify-between gap-3">
            <h3 class="font-semibold leading-snug line-clamp-2"><?= h($p['name'] ?: 'Bez názvu') ?></h3>
            <span class="shrink-0 rounded-full bg-slate-900 px-2.5 py-1 text-xs text-white"><?= h($p['shop']) ?></span>
          </div>

          <div class="mt-2 flex items-center justify-between">
            <div class="text-lg font-semibold">
              <?php if ($p['price'] !== null && $p['price'] !== ''): ?>
                <?= number_format((float)$p['price'], 0, ',', ' ') ?> Kč
              <?php else: ?>
                <span class="text-sm text-slate-500">Cena nenalezena</span>
              <?php endif; ?>
            </div>

            <a href="<?= h($p['url']) ?>" target="_blank" rel="noopener noreferrer nofollow"
               class="rounded-xl bg-slate-900 px-3 py-2 text-sm text-white hover:bg-slate-800">
              Přejít na produkt
            </a>
          </div>

          <div class="mt-2 text-xs text-slate-500">
            Aktualizováno: <?= h(date('Y-m-d H:i', strtotime($p['updated_at'] ?? ''))) ?>
            · Hlídání: <?= ((int)$p['watch_enabled'] === 1) ? 'ON' : 'OFF' ?>
          </div>

          <details class="mt-3 text-sm">
            <summary class="cursor-pointer text-slate-700">Historie cen</summary>
            <div class="mt-2 space-y-1">
              <?php $pid = (int)$p['id']; $rows = $history[$pid] ?? []; ?>
              <?php if (!$rows): ?>
                <div class="text-xs text-slate-500">Zatím bez historie.</div>
              <?php else: ?>
                <?php foreach ($rows as $r): ?>
                  <div class="flex justify-between text-xs text-slate-600">
                    <span><?= h(date('Y-m-d H:i', strtotime($r['checked_at']))) ?></span>
                    <span class="font-medium"><?= number_format((float)$r['price'], 0, ',', ' ') ?> Kč</span>
                  </div>
                <?php endforeach; ?>
              <?php endif; ?>
            </div>
          </details>
        </div>
      </article>
    <?php endforeach; ?>
  </div>
<?php endif; ?>

<!-- ADMIN SECTION -->
<section id="admin" class="mt-10">
  <div class="rounded-2xl border bg-white p-5 shadow-sm">
    <div class="flex items-center justify-between gap-4">
      <h2 class="text-base font-semibold">Admin</h2>

      <?php if ($is_admin): ?>
        <form method="post" class="m-0">
          <input type="hidden" name="action" value="logout">
          <button class="rounded-xl border px-3 py-2 text-sm hover:bg-slate-50">Odhlásit</button>
        </form>
      <?php endif; ?>
    </div>

    <?php if (!$is_admin): ?>
      <p class="mt-1 text-sm text-slate-600">Zadej PIN pro zobrazení adminu.</p>
      <form class="mt-4 flex flex-col gap-3 sm:flex-row sm:items-end" method="post" action="index.php#admin" autocomplete="off">
        <input type="hidden" name="action" value="login">
        <label class="grid gap-1 flex-1">
          <span class="text-sm font-medium">PIN</span>
          <input name="pin" inputmode="numeric" pattern="[0-9]*" required
                 class="rounded-xl border px-3 py-2 outline-none focus:ring"
                 placeholder="****" />
        </label>
        <button class="rounded-xl bg-slate-900 px-4 py-2 text-white hover:bg-slate-800">
          Odemknout
        </button>
      </form>
    <?php else: ?>
      <p class="mt-1 text-sm text-slate-600">Admin je odemčený. Přidej produkt:</p>

      <form class="mt-4 grid gap-3 md:grid-cols-2" method="post" action="add.php">
        <label class="grid gap-1 md:col-span-2">
          <span class="text-sm font-medium">URL produktu</span>
          <input name="url" required
                 class="rounded-xl border px-3 py-2 outline-none focus:ring"
                 placeholder="https://www.alza.cz/..." />
        </label>

        <label class="grid gap-1">
          <span class="text-sm font-medium">Obchod (tag)</span>
          <input name="shop"
                 class="rounded-xl border px-3 py-2 outline-none focus:ring"
                 placeholder="nech prázdné = auto detekce" />
        </label>

        <label class="grid gap-1">
          <span class="text-sm font-medium">Hlídání ceny</span>
          <select name="watch_enabled" class="rounded-xl border px-3 py-2 outline-none focus:ring">
            <option value="1" selected>Zapnout</option>
            <option value="0">Vypnout</option>
          </select>
        </label>

        <div class="md:col-span-2">
          <button class="rounded-xl bg-slate-900 px-4 py-2 text-white hover:bg-slate-800">
            Přidat a stáhnout data
          </button>
        </div>
      </form>
    <?php endif; ?>
  </div>
</section>

<?php include __DIR__ . '/partials/footer.php'; ?>
