<?php
require_once __DIR__ . '/functions.php';

$db = db();
$products = $db->query("SELECT * FROM products WHERE watch_enabled = 1")->fetchAll(PDO::FETCH_ASSOC);

if (!$products) {
    log_refresh("REFRESH: no watched products");
    exit;
}

foreach ($products as $p) {
    $id = (int)$p['id'];
    try {
        $data = scrape_product($p['url']);
    } catch (Throwable $e) {
        log_refresh("REFRESH FAILED id=$id url=" . $p['url'] . " | " . $e->getMessage());
        continue;
    }

    if ($data['price'] === null) {
        log_refresh("REFRESH: no price id=$id url=" . $p['url']);
        continue;
    }

    $new = (float)$data['price'];
    $old = ($p['price'] === null || $p['price'] === '') ? null : (float)$p['price'];
    $currency = $data['currency'] ?: ($p['currency'] ?: 'CZK');

    $name = $data['name'] ?: $p['name'];
    $image_url = $data['image_url'] ?: $p['image_url'];
    $image_path = $p['image_path'];

    if (!$image_path && $image_url) {
        $image_path = download_image($image_url, $id . '_' . $p['shop']);
    }

    $up = $db->prepare("UPDATE products SET name=?, price=?, currency=?, image_url=?, image_path=?, updated_at=? WHERE id=?");
    $up->execute([$name, $new, $currency, $image_url, $image_path, now_iso(), $id]);

    add_price_history($db, $id, $new, $currency);

    if ($old !== null && ($old - $new) >= DROP_THRESHOLD_CZK) {
        notify_drop($p, $old, $new);
    }

    log_refresh("REFRESH OK id=$id old=" . ($old === null ? 'null' : $old) . " new=$new url=" . $p['url']);
}

echo "OK\n";
