<?php
require_once __DIR__ . '/functions.php';
$title = 'Admin – ' . APP_TITLE;
include __DIR__ . '/partials/header.php';

$flash = '';
if (isset($_GET['ok'])) $flash = 'Produkt přidán / aktualizován.';
if (isset($_GET['err'])) $flash = 'Nepodařilo se stáhnout data. Zkontroluj URL nebo log.';
?>

<?php if ($flash): ?>
  <div class="mb-4 rounded-xl border bg-amber-50 px-4 py-3 text-amber-900"><?= h($flash) ?></div>
<?php endif; ?>

<div class="grid gap-6 md:grid-cols-2">
  <section class="rounded-2xl border bg-white p-5 shadow-sm">
    <h2 class="text-base font-semibold">Přidat produkt</h2>
    <p class="mt-1 text-sm text-slate-600">Vlož URL produktu. Obchod se detekuje automaticky (lze přepsat).</p>

    <form class="mt-4 grid gap-3" method="post" action="/add.php">
      <label class="grid gap-1">
        <span class="text-sm font-medium">URL produktu</span>
        <input name="url" required class="rounded-xl border px-3 py-2 outline-none focus:ring"
               placeholder="https://www.alza.cz/..." />
      </label>

      <label class="grid gap-1">
        <span class="text-sm font-medium">Obchod (tag)</span>
        <input name="shop" class="rounded-xl border px-3 py-2 outline-none focus:ring"
               placeholder="nech prázdné = auto detekce" />
        <span class="text-xs text-slate-500">Např. alza / czc / mall…</span>
      </label>

      <label class="grid gap-1">
        <span class="text-sm font-medium">Hlídání ceny</span>
        <select name="watch_enabled" class="rounded-xl border px-3 py-2 outline-none focus:ring">
          <option value="1" selected>Zapnout</option>
          <option value="0">Vypnout</option>
        </select>
      </label>

      <button class="rounded-xl bg-slate-900 px-4 py-2 text-white hover:bg-slate-800">
        Přidat a stáhnout data
      </button>
    </form>
  </section>

  <section class="rounded-2xl border bg-white p-5 shadow-sm">
    <h2 class="text-base font-semibold">Tip</h2>
    <p class="mt-2 text-sm text-slate-700">
      Hlídání ceny běží přes <code>refresh.php</code> – spusť ho cronem (viz README).
    </p>
  </section>
</div>

<?php include __DIR__ . '/partials/footer.php'; ?>
