# Hlídač cen (PHP + HTML/CSS/JS)

Co umí:
- Admin vloží URL produktu → uloží se do SQLite, pokusí se zjistit název, cenu v Kč a obrázek (JSON-LD/OG).
- Přehled produktů: obrázek, název, cena, tag obchodu, **odkaz na produkt**.
- Filtrování podle obchodu (JS).
- Hlídání ceny + historie cen + notifikace při poklesu (cron přes `refresh.php`).

## Požadavky
- PHP 8.1+ (doporučeno 8.2+)
- Rozšíření: `pdo_sqlite`, `dom`, `libxml`, `curl`, `openssl` (kvůli HTTPS)

## Spuštění (lokálně)
Ve složce projektu:
```bash
php -S 127.0.0.1:8000
```
Otevři:
- Přehled: http://127.0.0.1:8000/index.php
- Admin:   http://127.0.0.1:8000/admin.php

## Nastavení
Uprav `config.php`:
- `DROP_THRESHOLD_CZK` (pokles pro notifikaci)
- `NOTIFY_EMAIL` (pokud chceš e-mail; jinak se notifikace vypíše do logu)
- `REFRESH_LOG` (soubor pro log)

## Hlídání ceny (cron)
Spouštěj třeba každé 3 hodiny:
```bash
0 */3 * * * /usr/bin/php /cesta/k/projektu/refresh.php
```

## Poznámky
- Scraping je ukázkový: primárně čte schema.org Product (JSON-LD) a OG tagy.
- Každý e-shop může měnit strukturu → nejspolehlivější bývá JSON-LD.
