import os
import smtplib
from email.message import EmailMessage

def notify(subject: str, body: str) -> None:
    """Send notification email if SMTP configured; otherwise print to console."""
    host = os.getenv("SMTP_HOST", "").strip()
    to_addr = os.getenv("NOTIFY_TO", "").strip()

    if not host or not to_addr:
        print("\n=== NOTIFICATION ===")
        print(subject)
        print(body)
        print("=== /NOTIFICATION ===\n")
        return

    port = int(os.getenv("SMTP_PORT", "587"))
    user = os.getenv("SMTP_USER", "")
    password = os.getenv("SMTP_PASSWORD", "")
    from_addr = os.getenv("SMTP_FROM", user or "hlidac@example.com")

    msg = EmailMessage()
    msg["Subject"] = subject
    msg["From"] = from_addr
    msg["To"] = to_addr
    msg.set_content(body)

    with smtplib.SMTP(host, port) as server:
        server.starttls()
        if user and password:
            server.login(user, password)
        server.send_message(msg)
