from datetime import datetime
from sqlalchemy import Column, Integer, String, Float, DateTime, ForeignKey, Index
from sqlalchemy.orm import relationship
from .database import Base

class Product(Base):
    __tablename__ = "products"

    id = Column(Integer, primary_key=True)
    url = Column(String, unique=True, nullable=False, index=True)
    name = Column(String, nullable=True)
    price = Column(Float, nullable=True)
    currency = Column(String, default="CZK")
    shop = Column(String, nullable=False, index=True)
    image_url = Column(String, nullable=True)
    image_path = Column(String, nullable=True)

    created_at = Column(DateTime, default=datetime.utcnow)
    updated_at = Column(DateTime, default=datetime.utcnow)

    prices = relationship("PriceHistory", back_populates="product", cascade="all, delete-orphan")

class PriceHistory(Base):
    __tablename__ = "price_history"

    id = Column(Integer, primary_key=True)
    product_id = Column(Integer, ForeignKey("products.id", ondelete="CASCADE"), index=True)
    price = Column(Float, nullable=False)
    currency = Column(String, default="CZK")
    checked_at = Column(DateTime, default=datetime.utcnow, index=True)

    product = relationship("Product", back_populates="prices")

Index("ix_price_history_product_time", PriceHistory.product_id, PriceHistory.checked_at)
