# Hlídač cen – mini aplikace (FastAPI)

Co umí:
- Admin vloží odkaz na produkt → uloží se produkt, stáhne se fotka, zjistí se cena v Kč.
- Přehled produktů v moderním gridu (Tailwind CDN), filtrování podle obchodu (tag).
- Automatická detekce obchodu z URL (podle domény).
- Hlídání ceny na pozadí + historie cen + notifikace při poklesu ceny.

## Spuštění

```bash
python -m venv .venv
# Windows: .venv\Scripts\activate
source .venv/bin/activate

pip install -r requirements.txt
cp .env.example .env
uvicorn app.main:app --reload
```

Otevři:
- Přehled: http://127.0.0.1:8000
- Admin:   http://127.0.0.1:8000/admin

## Notifikace (email)

Doplň v `.env` SMTP_* a NOTIFY_TO.
Pokud SMTP není nastavené, notifikace se vypisují do konzole.

## Poznámky
- Scraping e-shopů se může měnit – je to ukázková implementace.
- Primárně se snažíme číst cenu/obrázek z JSON-LD (schema.org Product) a OG tagů.
